<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * GreffeCondImmunoSupp
 *
 * @ORM\Table(name="greffe_cond_immuno_supp", uniqueConstraints={@ORM\UniqueConstraint(name="uniq_gre_cis", columns={"gre_code", "cis_code"})}, indexes={@ORM\Index(name="fk_greffe_cond_immuno_supp_", columns={"cis_code"}), @ORM\Index(name="IDX_B1BB5FC470D09EBE", columns={"gre_code"})})
 * @ORM\Entity
 */
class GreffeCondImmunoSupp
{
    /**
     * @var int
     *
     * @ORM\Column(name="gci_code", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $gciCode;

    /**
     * @var \RAN\Entity\Greffe
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\Greffe")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="gre_code", referencedColumnName="gre_code")
     * })
     */
    private $greCode;

    /**
     * @var \RAN\Entity\CondImmunoSup
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\CondImmunoSup")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="cis_code", referencedColumnName="cis_code")
     * })
     */
    private $cisCode;



    /**
     * Get gciCode.
     *
     * @return int
     */
    public function getGciCode()
    {
        return $this->gciCode;
    }

    /**
     * Set greCode.
     *
     * @param \RAN\Entity\Greffe|null $greCode
     *
     * @return GreffeCondImmunoSupp
     */
    public function setGreCode(\RAN\Entity\Greffe $greCode = null)
    {
        $this->greCode = $greCode;

        return $this;
    }

    /**
     * Get greCode.
     *
     * @return \RAN\Entity\Greffe|null
     */
    public function getGreCode()
    {
        return $this->greCode;
    }

    /**
     * Set cisCode.
     *
     * @param \RAN\Entity\CondImmunoSup|null $cisCode
     *
     * @return GreffeCondImmunoSupp
     */
    public function setCisCode(\RAN\Entity\CondImmunoSup $cisCode = null)
    {
        $this->cisCode = $cisCode;

        return $this;
    }

    /**
     * Get cisCode.
     *
     * @return \RAN\Entity\CondImmunoSup|null
     */
    public function getCisCode()
    {
        return $this->cisCode;
    }
}
