<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * GreffeIncompatibiliteHla
 *
 * @ORM\Table(name="greffe_incompatibilite_hla", uniqueConstraints={@ORM\UniqueConstraint(name="uniq_gre_hla_vih", columns={"hla_code", "gre_code", "vih_code"})}, indexes={@ORM\Index(name="fk_greffe_incompatib_hla_gr", columns={"gre_code"}), @ORM\Index(name="fk_greffe_incompatib_hla_va", columns={"vih_code"}), @ORM\Index(name="IDX_5E8997B45802997", columns={"hla_code"})})
 * @ORM\Entity
 */
class GreffeIncompatibiliteHla
{
    /**
     * @var int
     *
     * @ORM\Column(name="gih_code", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $gihCode;

    /**
     * @var \RAN\Entity\ValIncompatibiliteHla
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\ValIncompatibiliteHla")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="vih_code", referencedColumnName="vih_code")
     * })
     */
    private $vihCode;

    /**
     * @var \RAN\Entity\GroupeHla
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\GroupeHla")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="hla_code", referencedColumnName="hla_code")
     * })
     */
    private $hlaCode;

    /**
     * @var \RAN\Entity\Greffe
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\Greffe")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="gre_code", referencedColumnName="gre_code")
     * })
     */
    private $greCode;



    /**
     * Get gihCode.
     *
     * @return int
     */
    public function getGihCode()
    {
        return $this->gihCode;
    }

    /**
     * Set vihCode.
     *
     * @param \RAN\Entity\ValIncompatibiliteHla|null $vihCode
     *
     * @return GreffeIncompatibiliteHla
     */
    public function setVihCode(\RAN\Entity\ValIncompatibiliteHla $vihCode = null)
    {
        $this->vihCode = $vihCode;

        return $this;
    }

    /**
     * Get vihCode.
     *
     * @return \RAN\Entity\ValIncompatibiliteHla|null
     */
    public function getVihCode()
    {
        return $this->vihCode;
    }

    /**
     * Set hlaCode.
     *
     * @param \RAN\Entity\GroupeHla|null $hlaCode
     *
     * @return GreffeIncompatibiliteHla
     */
    public function setHlaCode(\RAN\Entity\GroupeHla $hlaCode = null)
    {
        $this->hlaCode = $hlaCode;

        return $this;
    }

    /**
     * Get hlaCode.
     *
     * @return \RAN\Entity\GroupeHla|null
     */
    public function getHlaCode()
    {
        return $this->hlaCode;
    }

    /**
     * Set greCode.
     *
     * @param \RAN\Entity\Greffe|null $greCode
     *
     * @return GreffeIncompatibiliteHla
     */
    public function setGreCode(\RAN\Entity\Greffe $greCode = null)
    {
        $this->greCode = $greCode;

        return $this;
    }

    /**
     * Get greCode.
     *
     * @return \RAN\Entity\Greffe|null
     */
    public function getGreCode()
    {
        return $this->greCode;
    }
}
