<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * GroupeHla
 *
 * @ORM\Table(name="groupe_hla")
 * @ORM\Entity
 */
class GroupeHla
{
    /**
     * @var string
     *
     * @ORM\Column(name="hla_code", type="decimal", precision=2, scale=0, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $hlaCode;

    /**
     * @var string
     *
     * @ORM\Column(name="hla_libelle", type="string", length=10, nullable=false)
     */
    private $hlaLibelle;

    /**
     * @var string
     *
     * @ORM\Column(name="hla_ordre", type="decimal", precision=2, scale=0, nullable=false)
     */
    private $hlaOrdre;



    /**
     * Get hlaCode.
     *
     * @return string
     */
    public function getHlaCode()
    {
        return $this->hlaCode;
    }

    /**
     * Set hlaLibelle.
     *
     * @param string $hlaLibelle
     *
     * @return GroupeHla
     */
    public function setHlaLibelle($hlaLibelle)
    {
        $this->hlaLibelle = $hlaLibelle;

        return $this;
    }

    /**
     * Get hlaLibelle.
     *
     * @return string
     */
    public function getHlaLibelle()
    {
        return $this->hlaLibelle;
    }

    /**
     * Set hlaOrdre.
     *
     * @param string $hlaOrdre
     *
     * @return GroupeHla
     */
    public function setHlaOrdre($hlaOrdre)
    {
        $this->hlaOrdre = $hlaOrdre;

        return $this;
    }

    /**
     * Get hlaOrdre.
     *
     * @return string
     */
    public function getHlaOrdre()
    {
        return $this->hlaOrdre;
    }
}
