<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Habilite
 *
 * @ORM\Table(name="habilite", indexes={@ORM\Index(name="hab_code", columns={"hab_code"}), @ORM\Index(name="fca_code", columns={"fca_code"}), @ORM\Index(name="IDX_DA8E096A658D0D37", columns={"rol_code"})})
 * @ORM\Entity
 */
class Habilite
{
    /**
     * @var \RAN\Entity\Role
     *
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     * @ORM\OneToOne(targetEntity="RAN\Entity\Role")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="rol_code", referencedColumnName="rol_code")
     * })
     */
    private $rolCode;

    /**
     * @var \RAN\Entity\Habilitation
     *
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     * @ORM\OneToOne(targetEntity="RAN\Entity\Habilitation")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="hab_code", referencedColumnName="hab_code")
     * })
     */
    private $habCode;

    /**
     * @var \RAN\Entity\FonctionApplicative
     *
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     * @ORM\OneToOne(targetEntity="RAN\Entity\FonctionApplicative")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="fca_code", referencedColumnName="fca_code")
     * })
     */
    private $fcaCode;



    /**
     * Set rolCode.
     *
     * @param \RAN\Entity\Role $rolCode
     *
     * @return Habilite
     */
    public function setRolCode(\RAN\Entity\Role $rolCode)
    {
        $this->rolCode = $rolCode;

        return $this;
    }

    /**
     * Get rolCode.
     *
     * @return \RAN\Entity\Role
     */
    public function getRolCode()
    {
        return $this->rolCode;
    }

    /**
     * Set habCode.
     *
     * @param \RAN\Entity\Habilitation $habCode
     *
     * @return Habilite
     */
    public function setHabCode(\RAN\Entity\Habilitation $habCode)
    {
        $this->habCode = $habCode;

        return $this;
    }

    /**
     * Get habCode.
     *
     * @return \RAN\Entity\Habilitation
     */
    public function getHabCode()
    {
        return $this->habCode;
    }

    /**
     * Set fcaCode.
     *
     * @param \RAN\Entity\FonctionApplicative $fcaCode
     *
     * @return Habilite
     */
    public function setFcaCode(\RAN\Entity\FonctionApplicative $fcaCode)
    {
        $this->fcaCode = $fcaCode;

        return $this;
    }

    /**
     * Get fcaCode.
     *
     * @return \RAN\Entity\FonctionApplicative
     */
    public function getFcaCode()
    {
        return $this->fcaCode;
    }
}
