<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * HlaReinDroit
 *
 * @ORM\Table(name="hla_rein_droit", uniqueConstraints={@ORM\UniqueConstraint(name="uniq_gre_pbi", columns={"gre_code", "pbi_code"})}, indexes={@ORM\Index(name="fk_hla_rein_droit2", columns={"pbi_code"}), @ORM\Index(name="IDX_A22275F070D09EBE", columns={"gre_code"})})
 * @ORM\Entity
 */
class HlaReinDroit
{
    /**
     * @var int
     *
     * @ORM\Column(name="hrd_code", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $hrdCode;

    /**
     * @var string
     *
     * @ORM\Column(name="hla_rg_valeur", type="string", length=20, nullable=false)
     */
    private $hlaRgValeur;

    /**
     * @var \RAN\Entity\Greffe
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\Greffe")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="gre_code", referencedColumnName="gre_code")
     * })
     */
    private $greCode;

    /**
     * @var \RAN\Entity\ParametresBiologiques
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\ParametresBiologiques")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="pbi_code", referencedColumnName="pbi_code")
     * })
     */
    private $pbiCode;



    /**
     * Get hrdCode.
     *
     * @return int
     */
    public function getHrdCode()
    {
        return $this->hrdCode;
    }

    /**
     * Set hlaRgValeur.
     *
     * @param string $hlaRgValeur
     *
     * @return HlaReinDroit
     */
    public function setHlaRgValeur($hlaRgValeur)
    {
        $this->hlaRgValeur = $hlaRgValeur;

        return $this;
    }

    /**
     * Get hlaRgValeur.
     *
     * @return string
     */
    public function getHlaRgValeur()
    {
        return $this->hlaRgValeur;
    }

    /**
     * Set greCode.
     *
     * @param \RAN\Entity\Greffe|null $greCode
     *
     * @return HlaReinDroit
     */
    public function setGreCode(\RAN\Entity\Greffe $greCode = null)
    {
        $this->greCode = $greCode;

        return $this;
    }

    /**
     * Get greCode.
     *
     * @return \RAN\Entity\Greffe|null
     */
    public function getGreCode()
    {
        return $this->greCode;
    }

    /**
     * Set pbiCode.
     *
     * @param \RAN\Entity\ParametresBiologiques|null $pbiCode
     *
     * @return HlaReinDroit
     */
    public function setPbiCode(\RAN\Entity\ParametresBiologiques $pbiCode = null)
    {
        $this->pbiCode = $pbiCode;

        return $this;
    }

    /**
     * Get pbiCode.
     *
     * @return \RAN\Entity\ParametresBiologiques|null
     */
    public function getPbiCode()
    {
        return $this->pbiCode;
    }
}
