<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * HlaReinGauche
 *
 * @ORM\Table(name="hla_rein_gauche", uniqueConstraints={@ORM\UniqueConstraint(name="uniq_gre_pbi", columns={"gre_code", "pbi_code"})}, indexes={@ORM\Index(name="fk_hla_rein_gauche2", columns={"pbi_code"}), @ORM\Index(name="IDX_27555ABF70D09EBE", columns={"gre_code"})})
 * @ORM\Entity
 */
class HlaReinGauche
{
    /**
     * @var int
     *
     * @ORM\Column(name="hrg_code", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $hrgCode;

    /**
     * @var string
     *
     * @ORM\Column(name="hla_rg_valeur", type="string", length=20, nullable=false)
     */
    private $hlaRgValeur;

    /**
     * @var \RAN\Entity\Greffe
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\Greffe")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="gre_code", referencedColumnName="gre_code")
     * })
     */
    private $greCode;

    /**
     * @var \RAN\Entity\ParametresBiologiques
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\ParametresBiologiques")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="pbi_code", referencedColumnName="pbi_code")
     * })
     */
    private $pbiCode;



    /**
     * Get hrgCode.
     *
     * @return int
     */
    public function getHrgCode()
    {
        return $this->hrgCode;
    }

    /**
     * Set hlaRgValeur.
     *
     * @param string $hlaRgValeur
     *
     * @return HlaReinGauche
     */
    public function setHlaRgValeur($hlaRgValeur)
    {
        $this->hlaRgValeur = $hlaRgValeur;

        return $this;
    }

    /**
     * Get hlaRgValeur.
     *
     * @return string
     */
    public function getHlaRgValeur()
    {
        return $this->hlaRgValeur;
    }

    /**
     * Set greCode.
     *
     * @param \RAN\Entity\Greffe|null $greCode
     *
     * @return HlaReinGauche
     */
    public function setGreCode(\RAN\Entity\Greffe $greCode = null)
    {
        $this->greCode = $greCode;

        return $this;
    }

    /**
     * Get greCode.
     *
     * @return \RAN\Entity\Greffe|null
     */
    public function getGreCode()
    {
        return $this->greCode;
    }

    /**
     * Set pbiCode.
     *
     * @param \RAN\Entity\ParametresBiologiques|null $pbiCode
     *
     * @return HlaReinGauche
     */
    public function setPbiCode(\RAN\Entity\ParametresBiologiques $pbiCode = null)
    {
        $this->pbiCode = $pbiCode;

        return $this;
    }

    /**
     * Get pbiCode.
     *
     * @return \RAN\Entity\ParametresBiologiques|null
     */
    public function getPbiCode()
    {
        return $this->pbiCode;
    }
}
