<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * IrmIliaques
 *
 * @ORM\Table(name="irm_iliaques")
 * @ORM\Entity
 */
class IrmIliaques
{
    /**
     * @var string|null
     *
     * @ORM\Column(name="iri_comment", type="string", length=500, nullable=true)
     */
    private $iriComment;

    /**
     * @var \RAN\Entity\AntecedentNeoplasique
     *
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     * @ORM\OneToOne(targetEntity="RAN\Entity\AntecedentNeoplasique")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="ant_code", referencedColumnName="ant_code")
     * })
     */
    private $antCode;



    /**
     * Set iriComment.
     *
     * @param string|null $iriComment
     *
     * @return IrmIliaques
     */
    public function setIriComment($iriComment = null)
    {
        $this->iriComment = $iriComment;

        return $this;
    }

    /**
     * Get iriComment.
     *
     * @return string|null
     */
    public function getIriComment()
    {
        return $this->iriComment;
    }

    /**
     * Set antCode.
     *
     * @param \RAN\Entity\AntecedentNeoplasique $antCode
     *
     * @return IrmIliaques
     */
    public function setAntCode(\RAN\Entity\AntecedentNeoplasique $antCode)
    {
        $this->antCode = $antCode;

        return $this;
    }

    /**
     * Get antCode.
     *
     * @return \RAN\Entity\AntecedentNeoplasique
     */
    public function getAntCode()
    {
        return $this->antCode;
    }
}
