<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * LiquidePerfusion
 *
 * @ORM\Table(name="liquide_perfusion")
 * @ORM\Entity
 */
class LiquidePerfusion
{
    /**
     * @var string
     *
     * @ORM\Column(name="lip_code", type="decimal", precision=2, scale=0, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $lipCode;

    /**
     * @var string
     *
     * @ORM\Column(name="lip_libelle", type="string", length=100, nullable=false)
     */
    private $lipLibelle;

    /**
     * @var string
     *
     * @ORM\Column(name="lip_ordre", type="decimal", precision=2, scale=0, nullable=false)
     */
    private $lipOrdre;



    /**
     * Get lipCode.
     *
     * @return string
     */
    public function getLipCode()
    {
        return $this->lipCode;
    }

    /**
     * Set lipLibelle.
     *
     * @param string $lipLibelle
     *
     * @return LiquidePerfusion
     */
    public function setLipLibelle($lipLibelle)
    {
        $this->lipLibelle = $lipLibelle;

        return $this;
    }

    /**
     * Get lipLibelle.
     *
     * @return string
     */
    public function getLipLibelle()
    {
        return $this->lipLibelle;
    }

    /**
     * Set lipOrdre.
     *
     * @param string $lipOrdre
     *
     * @return LiquidePerfusion
     */
    public function setLipOrdre($lipOrdre)
    {
        $this->lipOrdre = $lipOrdre;

        return $this;
    }

    /**
     * Get lipOrdre.
     *
     * @return string
     */
    public function getLipOrdre()
    {
        return $this->lipOrdre;
    }
}
