<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Medecin
 *
 * @ORM\Table(name="medecin", indexes={@ORM\Index(name="spm_code", columns={"spm_code"})})
 * @ORM\Entity
 */
class Medecin
{
    /**
     * @var string|null
     *
     * @ORM\Column(name="med_rpps", type="string", length=11, nullable=true)
     */
    private $medRpps;

    /**
     * @var \RAN\Entity\Personne
     *
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     * @ORM\OneToOne(targetEntity="RAN\Entity\Personne")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="per_code", referencedColumnName="per_code")
     * })
     */
    private $perCode;

    /**
     * @var \RAN\Entity\SpecialiteMedicale
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\SpecialiteMedicale")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="spm_code", referencedColumnName="spm_code")
     * })
     */
    private $spmCode;



    /**
     * Set medRpps.
     *
     * @param string|null $medRpps
     *
     * @return Medecin
     */
    public function setMedRpps($medRpps = null)
    {
        $this->medRpps = $medRpps;

        return $this;
    }

    /**
     * Get medRpps.
     *
     * @return string|null
     */
    public function getMedRpps()
    {
        return $this->medRpps;
    }

    /**
     * Set perCode.
     *
     * @param \RAN\Entity\Personne $perCode
     *
     * @return Medecin
     */
    public function setPerCode(\RAN\Entity\Personne $perCode)
    {
        $this->perCode = $perCode;

        return $this;
    }

    /**
     * Get perCode.
     *
     * @return \RAN\Entity\Personne
     */
    public function getPerCode()
    {
        return $this->perCode;
    }

    /**
     * Set spmCode.
     *
     * @param \RAN\Entity\SpecialiteMedicale|null $spmCode
     *
     * @return Medecin
     */
    public function setSpmCode(\RAN\Entity\SpecialiteMedicale $spmCode = null)
    {
        $this->spmCode = $spmCode;

        return $this;
    }

    /**
     * Get spmCode.
     *
     * @return \RAN\Entity\SpecialiteMedicale|null
     */
    public function getSpmCode()
    {
        return $this->spmCode;
    }
}
