<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Medicament
 *
 * @ORM\Table(name="medicament", indexes={@ORM\Index(name="medi_nom_com", columns={"medi_nom_com", "medi_access"})})
 * @ORM\Entity
 */
class Medicament
{
    /**
     * @var int
     *
     * @ORM\Column(name="medi_code", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $mediCode;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="medi_dt_creat", type="date", nullable=true)
     */
    private $mediDtCreat;

    /**
     * @var string|null
     *
     * @ORM\Column(name="medi_nom_com", type="string", length=50, nullable=true)
     */
    private $mediNomCom;

    /**
     * @var string|null
     *
     * @ORM\Column(name="medi_dci", type="string", length=50, nullable=true)
     */
    private $mediDci;

    /**
     * @var string|null
     *
     * @ORM\Column(name="medi_dosage", type="string", length=50, nullable=true)
     */
    private $mediDosage;

    /**
     * @var string|null
     *
     * @ORM\Column(name="medi_unite", type="string", length=50, nullable=true)
     */
    private $mediUnite;

    /**
     * @var string|null
     *
     * @ORM\Column(name="medi_comment", type="string", length=500, nullable=true)
     */
    private $mediComment;

    /**
     * @var bool|null
     *
     * @ORM\Column(name="medi_access", type="boolean", nullable=true)
     */
    private $mediAccess;

    /**
     * @var bool
     *
     * @ORM\Column(name="medi_non_substituable", type="boolean", nullable=false, options={"comment"="Champ indiquant si le medicament ne peut pas etre substituable"})
     */
    private $mediNonSubstituable = '0';



    /**
     * Get mediCode.
     *
     * @return int
     */
    public function getMediCode()
    {
        return $this->mediCode;
    }

    /**
     * Set mediDtCreat.
     *
     * @param \DateTime|null $mediDtCreat
     *
     * @return Medicament
     */
    public function setMediDtCreat($mediDtCreat = null)
    {
        $this->mediDtCreat = $mediDtCreat;

        return $this;
    }

    /**
     * Get mediDtCreat.
     *
     * @return \DateTime|null
     */
    public function getMediDtCreat()
    {
        return $this->mediDtCreat;
    }

    /**
     * Set mediNomCom.
     *
     * @param string|null $mediNomCom
     *
     * @return Medicament
     */
    public function setMediNomCom($mediNomCom = null)
    {
        $this->mediNomCom = $mediNomCom;

        return $this;
    }

    /**
     * Get mediNomCom.
     *
     * @return string|null
     */
    public function getMediNomCom()
    {
        return $this->mediNomCom;
    }

    /**
     * Set mediDci.
     *
     * @param string|null $mediDci
     *
     * @return Medicament
     */
    public function setMediDci($mediDci = null)
    {
        $this->mediDci = $mediDci;

        return $this;
    }

    /**
     * Get mediDci.
     *
     * @return string|null
     */
    public function getMediDci()
    {
        return $this->mediDci;
    }

    /**
     * Set mediDosage.
     *
     * @param string|null $mediDosage
     *
     * @return Medicament
     */
    public function setMediDosage($mediDosage = null)
    {
        $this->mediDosage = $mediDosage;

        return $this;
    }

    /**
     * Get mediDosage.
     *
     * @return string|null
     */
    public function getMediDosage()
    {
        return $this->mediDosage;
    }

    /**
     * Set mediUnite.
     *
     * @param string|null $mediUnite
     *
     * @return Medicament
     */
    public function setMediUnite($mediUnite = null)
    {
        $this->mediUnite = $mediUnite;

        return $this;
    }

    /**
     * Get mediUnite.
     *
     * @return string|null
     */
    public function getMediUnite()
    {
        return $this->mediUnite;
    }

    /**
     * Set mediComment.
     *
     * @param string|null $mediComment
     *
     * @return Medicament
     */
    public function setMediComment($mediComment = null)
    {
        $this->mediComment = $mediComment;

        return $this;
    }

    /**
     * Get mediComment.
     *
     * @return string|null
     */
    public function getMediComment()
    {
        return $this->mediComment;
    }

    /**
     * Set mediAccess.
     *
     * @param bool|null $mediAccess
     *
     * @return Medicament
     */
    public function setMediAccess($mediAccess = null)
    {
        $this->mediAccess = $mediAccess;

        return $this;
    }

    /**
     * Get mediAccess.
     *
     * @return bool|null
     */
    public function getMediAccess()
    {
        return $this->mediAccess;
    }

    /**
     * Set mediNonSubstituable.
     *
     * @param bool $mediNonSubstituable
     *
     * @return Medicament
     */
    public function setMediNonSubstituable($mediNonSubstituable)
    {
        $this->mediNonSubstituable = $mediNonSubstituable;

        return $this;
    }

    /**
     * Get mediNonSubstituable.
     *
     * @return bool
     */
    public function getMediNonSubstituable()
    {
        return $this->mediNonSubstituable;
    }
}
