<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * MorphologieReins
 *
 * @ORM\Table(name="morphologie_reins")
 * @ORM\Entity
 */
class MorphologieReins
{
    /**
     * @var string|null
     *
     * @ORM\Column(name="mor_comment", type="string", length=500, nullable=true)
     */
    private $morComment;

    /**
     * @var \RAN\Entity\AntCardio
     *
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     * @ORM\OneToOne(targetEntity="RAN\Entity\AntCardio")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="ant_code", referencedColumnName="ant_code")
     * })
     */
    private $antCode;



    /**
     * Set morComment.
     *
     * @param string|null $morComment
     *
     * @return MorphologieReins
     */
    public function setMorComment($morComment = null)
    {
        $this->morComment = $morComment;

        return $this;
    }

    /**
     * Get morComment.
     *
     * @return string|null
     */
    public function getMorComment()
    {
        return $this->morComment;
    }

    /**
     * Set antCode.
     *
     * @param \RAN\Entity\AntCardio $antCode
     *
     * @return MorphologieReins
     */
    public function setAntCode(\RAN\Entity\AntCardio $antCode)
    {
        $this->antCode = $antCode;

        return $this;
    }

    /**
     * Get antCode.
     *
     * @return \RAN\Entity\AntCardio
     */
    public function getAntCode()
    {
        return $this->antCode;
    }
}
