<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Ordonnance
 *
 * @ORM\Table(name="ordonnance", indexes={@ORM\Index(name="fk_ordonnance_consult", columns={"csl_code"}), @ORM\Index(name="fk_fk_ordonnance_type_ordo", columns={"tpo_code"})})
 * @ORM\Entity
 */
class Ordonnance
{
    /**
     * @var int
     *
     * @ORM\Column(name="ord_code", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $ordCode;

    /**
     * @var \RAN\Entity\TypeOrdonnance
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\TypeOrdonnance")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="tpo_code", referencedColumnName="tpo_code")
     * })
     */
    private $tpoCode;

    /**
     * @var \RAN\Entity\Consultation
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\Consultation")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="csl_code", referencedColumnName="csl_code")
     * })
     */
    private $cslCode;



    /**
     * Get ordCode.
     *
     * @return int
     */
    public function getOrdCode()
    {
        return $this->ordCode;
    }

    /**
     * Set tpoCode.
     *
     * @param \RAN\Entity\TypeOrdonnance|null $tpoCode
     *
     * @return Ordonnance
     */
    public function setTpoCode(\RAN\Entity\TypeOrdonnance $tpoCode = null)
    {
        $this->tpoCode = $tpoCode;

        return $this;
    }

    /**
     * Get tpoCode.
     *
     * @return \RAN\Entity\TypeOrdonnance|null
     */
    public function getTpoCode()
    {
        return $this->tpoCode;
    }

    /**
     * Set cslCode.
     *
     * @param \RAN\Entity\Consultation|null $cslCode
     *
     * @return Ordonnance
     */
    public function setCslCode(\RAN\Entity\Consultation $cslCode = null)
    {
        $this->cslCode = $cslCode;

        return $this;
    }

    /**
     * Get cslCode.
     *
     * @return \RAN\Entity\Consultation|null
     */
    public function getCslCode()
    {
        return $this->cslCode;
    }
}
