<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ParametresBiologiques
 *
 * @ORM\Table(name="parametres_biologiques", indexes={@ORM\Index(name="fk_param_biologique_unite_param", columns={"upa_code"}), @ORM\Index(name="fk_fk_param_bio_type_param_bio", columns={"tpb_code"})})
 * @ORM\Entity
 */
class ParametresBiologiques
{
    /**
     * @var int
     *
     * @ORM\Column(name="pbi_code", type="smallint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $pbiCode;

    /**
     * @var string
     *
     * @ORM\Column(name="pbi_libelle", type="string", length=50, nullable=false)
     */
    private $pbiLibelle;

    /**
     * @var int|null
     *
     * @ORM\Column(name="pbi_ordre", type="smallint", nullable=true)
     */
    private $pbiOrdre;

    /**
     * @var bool
     *
     * @ORM\Column(name="pbi_bool", type="boolean", nullable=false)
     */
    private $pbiBool = '0';

    /**
     * @var string|null
     *
     * @ORM\Column(name="pbi_format", type="string", length=8, nullable=true)
     */
    private $pbiFormat;

    /**
     * @var float|null
     *
     * @ORM\Column(name="pbi_min", type="float", precision=10, scale=0, nullable=true)
     */
    private $pbiMin;

    /**
     * @var float|null
     *
     * @ORM\Column(name="pbi_max", type="float", precision=10, scale=0, nullable=true)
     */
    private $pbiMax;

    /**
     * @var \RAN\Entity\TypeParametreBiologique
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\TypeParametreBiologique")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="tpb_code", referencedColumnName="tpb_code")
     * })
     */
    private $tpbCode;

    /**
     * @var \RAN\Entity\UniteParam
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\UniteParam")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="upa_code", referencedColumnName="upa_code")
     * })
     */
    private $upaCode;



    /**
     * Get pbiCode.
     *
     * @return int
     */
    public function getPbiCode()
    {
        return $this->pbiCode;
    }

    /**
     * Set pbiLibelle.
     *
     * @param string $pbiLibelle
     *
     * @return ParametresBiologiques
     */
    public function setPbiLibelle($pbiLibelle)
    {
        $this->pbiLibelle = $pbiLibelle;

        return $this;
    }

    /**
     * Get pbiLibelle.
     *
     * @return string
     */
    public function getPbiLibelle()
    {
        return $this->pbiLibelle;
    }

    /**
     * Set pbiOrdre.
     *
     * @param int|null $pbiOrdre
     *
     * @return ParametresBiologiques
     */
    public function setPbiOrdre($pbiOrdre = null)
    {
        $this->pbiOrdre = $pbiOrdre;

        return $this;
    }

    /**
     * Get pbiOrdre.
     *
     * @return int|null
     */
    public function getPbiOrdre()
    {
        return $this->pbiOrdre;
    }

    /**
     * Set pbiBool.
     *
     * @param bool $pbiBool
     *
     * @return ParametresBiologiques
     */
    public function setPbiBool($pbiBool)
    {
        $this->pbiBool = $pbiBool;

        return $this;
    }

    /**
     * Get pbiBool.
     *
     * @return bool
     */
    public function getPbiBool()
    {
        return $this->pbiBool;
    }

    /**
     * Set pbiFormat.
     *
     * @param string|null $pbiFormat
     *
     * @return ParametresBiologiques
     */
    public function setPbiFormat($pbiFormat = null)
    {
        $this->pbiFormat = $pbiFormat;

        return $this;
    }

    /**
     * Get pbiFormat.
     *
     * @return string|null
     */
    public function getPbiFormat()
    {
        return $this->pbiFormat;
    }

    /**
     * Set pbiMin.
     *
     * @param float|null $pbiMin
     *
     * @return ParametresBiologiques
     */
    public function setPbiMin($pbiMin = null)
    {
        $this->pbiMin = $pbiMin;

        return $this;
    }

    /**
     * Get pbiMin.
     *
     * @return float|null
     */
    public function getPbiMin()
    {
        return $this->pbiMin;
    }

    /**
     * Set pbiMax.
     *
     * @param float|null $pbiMax
     *
     * @return ParametresBiologiques
     */
    public function setPbiMax($pbiMax = null)
    {
        $this->pbiMax = $pbiMax;

        return $this;
    }

    /**
     * Get pbiMax.
     *
     * @return float|null
     */
    public function getPbiMax()
    {
        return $this->pbiMax;
    }

    /**
     * Set tpbCode.
     *
     * @param \RAN\Entity\TypeParametreBiologique|null $tpbCode
     *
     * @return ParametresBiologiques
     */
    public function setTpbCode(\RAN\Entity\TypeParametreBiologique $tpbCode = null)
    {
        $this->tpbCode = $tpbCode;

        return $this;
    }

    /**
     * Get tpbCode.
     *
     * @return \RAN\Entity\TypeParametreBiologique|null
     */
    public function getTpbCode()
    {
        return $this->tpbCode;
    }

    /**
     * Set upaCode.
     *
     * @param \RAN\Entity\UniteParam|null $upaCode
     *
     * @return ParametresBiologiques
     */
    public function setUpaCode(\RAN\Entity\UniteParam $upaCode = null)
    {
        $this->upaCode = $upaCode;

        return $this;
    }

    /**
     * Get upaCode.
     *
     * @return \RAN\Entity\UniteParam|null
     */
    public function getUpaCode()
    {
        return $this->upaCode;
    }
}
