<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Parente
 *
 * @ORM\Table(name="parente")
 * @ORM\Entity
 */
class Parente
{
    /**
     * @var string
     *
     * @ORM\Column(name="par_code", type="decimal", precision=2, scale=0, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $parCode;

    /**
     * @var string
     *
     * @ORM\Column(name="par_libelle", type="string", length=50, nullable=false)
     */
    private $parLibelle;

    /**
     * @var string
     *
     * @ORM\Column(name="par_ordre", type="decimal", precision=2, scale=0, nullable=false)
     */
    private $parOrdre;



    /**
     * Get parCode.
     *
     * @return string
     */
    public function getParCode()
    {
        return $this->parCode;
    }

    /**
     * Set parLibelle.
     *
     * @param string $parLibelle
     *
     * @return Parente
     */
    public function setParLibelle($parLibelle)
    {
        $this->parLibelle = $parLibelle;

        return $this;
    }

    /**
     * Get parLibelle.
     *
     * @return string
     */
    public function getParLibelle()
    {
        return $this->parLibelle;
    }

    /**
     * Set parOrdre.
     *
     * @param string $parOrdre
     *
     * @return Parente
     */
    public function setParOrdre($parOrdre)
    {
        $this->parOrdre = $parOrdre;

        return $this;
    }

    /**
     * Get parOrdre.
     *
     * @return string
     */
    public function getParOrdre()
    {
        return $this->parOrdre;
    }
}
