<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Patient
 *
 * @ORM\Table(name="patient", indexes={@ORM\Index(name="fk_patient_centre_dialyse", columns={"cdi_code"}), @ORM\Index(name="fk_patient_situation_familiale", columns={"sif_code"})})
 * @ORM\Entity
 */
class Patient
{
    /**
     * @var string|null
     *
     * @ORM\Column(name="pat_num_venue", type="string", length=50, nullable=true)
     */
    private $patNumVenue;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="pat_dt_creat", type="date", nullable=true)
     */
    private $patDtCreat;

    /**
     * @var string|null
     *
     * @ORM\Column(name="pat_nom_jf", type="string", length=50, nullable=true)
     */
    private $patNomJf;

    /**
     * @var string
     *
     * @ORM\Column(name="pat_sexe", type="string", length=1, nullable=false, options={"fixed"=true})
     */
    private $patSexe;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="pat_dt_naiss", type="date", nullable=true)
     */
    private $patDtNaiss;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="pat_dt_deces", type="date", nullable=true)
     */
    private $patDtDeces;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="pat_dt_dc", type="date", nullable=true)
     */
    private $patDtDc;

    /**
     * @var string|null
     *
     * @ORM\Column(name="pat_no_efg", type="string", length=20, nullable=true)
     */
    private $patNoEfg;

    /**
     * @var string|null
     *
     * @ORM\Column(name="pat_no_ss", type="string", length=18, nullable=true, options={"fixed"=true})
     */
    private $patNoSs;

    /**
     * @var string
     *
     * @ORM\Column(name="pat_ipum", type="string", length=15, nullable=false)
     */
    private $patIpum;

    /**
     * @var bool|null
     *
     * @ORM\Column(name="pat_dossier_res", type="boolean", nullable=true)
     */
    private $patDossierRes;

    /**
     * @var bool|null
     *
     * @ORM\Column(name="pat_actif", type="boolean", nullable=true)
     */
    private $patActif;

    /**
     * @var bool|null
     *
     * @ORM\Column(name="pat_sdf", type="boolean", nullable=true)
     */
    private $patSdf;

    /**
     * @var int|null
     *
     * @ORM\Column(name="pat_nb_enf", type="smallint", nullable=true)
     */
    private $patNbEnf;

    /**
     * @var int|null
     *
     * @ORM\Column(name="pat_code_access", type="integer", nullable=true)
     */
    private $patCodeAccess;

    /**
     * @var \RAN\Entity\Personne
     *
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     * @ORM\OneToOne(targetEntity="RAN\Entity\Personne")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="per_code", referencedColumnName="per_code")
     * })
     */
    private $perCode;

    /**
     * @var \RAN\Entity\CentreDialyse
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\CentreDialyse")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="cdi_code", referencedColumnName="cdi_code")
     * })
     */
    private $cdiCode;

    /**
     * @var \RAN\Entity\SituationFamiliale
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\SituationFamiliale")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="sif_code", referencedColumnName="sif_code")
     * })
     */
    private $sifCode;

    /**
     * @var \Doctrine\Common\Collections\Collection
     *
     * @ORM\ManyToMany(targetEntity="RAN\Entity\EtpMotifRefus", inversedBy="perCode")
     * @ORM\JoinTable(name="etp_patient_refus_etp",
     *   joinColumns={
     *     @ORM\JoinColumn(name="per_code", referencedColumnName="per_code")
     *   },
     *   inverseJoinColumns={
     *     @ORM\JoinColumn(name="mre_code", referencedColumnName="mre_code")
     *   }
     * )
     */
    private $mreCode;

    /**
     * @var \Doctrine\Common\Collections\Collection
     *
     * @ORM\ManyToMany(targetEntity="RAN\Entity\Protocole", mappedBy="perCodePat")
     */
    private $prtCode;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->mreCode = new \Doctrine\Common\Collections\ArrayCollection();
        $this->prtCode = new \Doctrine\Common\Collections\ArrayCollection();
    }


    /**
     * Set patNumVenue.
     *
     * @param string|null $patNumVenue
     *
     * @return Patient
     */
    public function setPatNumVenue($patNumVenue = null)
    {
        $this->patNumVenue = $patNumVenue;

        return $this;
    }

    /**
     * Get patNumVenue.
     *
     * @return string|null
     */
    public function getPatNumVenue()
    {
        return $this->patNumVenue;
    }

    /**
     * Set patDtCreat.
     *
     * @param \DateTime|null $patDtCreat
     *
     * @return Patient
     */
    public function setPatDtCreat($patDtCreat = null)
    {
        $this->patDtCreat = $patDtCreat;

        return $this;
    }

    /**
     * Get patDtCreat.
     *
     * @return \DateTime|null
     */
    public function getPatDtCreat()
    {
        return $this->patDtCreat;
    }

    /**
     * Set patNomJf.
     *
     * @param string|null $patNomJf
     *
     * @return Patient
     */
    public function setPatNomJf($patNomJf = null)
    {
        $this->patNomJf = $patNomJf;

        return $this;
    }

    /**
     * Get patNomJf.
     *
     * @return string|null
     */
    public function getPatNomJf()
    {
        return $this->patNomJf;
    }

    /**
     * Set patSexe.
     *
     * @param string $patSexe
     *
     * @return Patient
     */
    public function setPatSexe($patSexe)
    {
        $this->patSexe = $patSexe;

        return $this;
    }

    /**
     * Get patSexe.
     *
     * @return string
     */
    public function getPatSexe()
    {
        return $this->patSexe;
    }

    /**
     * Set patDtNaiss.
     *
     * @param \DateTime|null $patDtNaiss
     *
     * @return Patient
     */
    public function setPatDtNaiss($patDtNaiss = null)
    {
        $this->patDtNaiss = $patDtNaiss;

        return $this;
    }

    /**
     * Get patDtNaiss.
     *
     * @return \DateTime|null
     */
    public function getPatDtNaiss()
    {
        return $this->patDtNaiss;
    }

    /**
     * Set patDtDeces.
     *
     * @param \DateTime|null $patDtDeces
     *
     * @return Patient
     */
    public function setPatDtDeces($patDtDeces = null)
    {
        $this->patDtDeces = $patDtDeces;

        return $this;
    }

    /**
     * Get patDtDeces.
     *
     * @return \DateTime|null
     */
    public function getPatDtDeces()
    {
        return $this->patDtDeces;
    }

    /**
     * Set patDtDc.
     *
     * @param \DateTime|null $patDtDc
     *
     * @return Patient
     */
    public function setPatDtDc($patDtDc = null)
    {
        $this->patDtDc = $patDtDc;

        return $this;
    }

    /**
     * Get patDtDc.
     *
     * @return \DateTime|null
     */
    public function getPatDtDc()
    {
        return $this->patDtDc;
    }

    /**
     * Set patNoEfg.
     *
     * @param string|null $patNoEfg
     *
     * @return Patient
     */
    public function setPatNoEfg($patNoEfg = null)
    {
        $this->patNoEfg = $patNoEfg;

        return $this;
    }

    /**
     * Get patNoEfg.
     *
     * @return string|null
     */
    public function getPatNoEfg()
    {
        return $this->patNoEfg;
    }

    /**
     * Set patNoSs.
     *
     * @param string|null $patNoSs
     *
     * @return Patient
     */
    public function setPatNoSs($patNoSs = null)
    {
        $this->patNoSs = $patNoSs;

        return $this;
    }

    /**
     * Get patNoSs.
     *
     * @return string|null
     */
    public function getPatNoSs()
    {
        return $this->patNoSs;
    }

    /**
     * Set patIpum.
     *
     * @param string $patIpum
     *
     * @return Patient
     */
    public function setPatIpum($patIpum)
    {
        $this->patIpum = $patIpum;

        return $this;
    }

    /**
     * Get patIpum.
     *
     * @return string
     */
    public function getPatIpum()
    {
        return $this->patIpum;
    }

    /**
     * Set patDossierRes.
     *
     * @param bool|null $patDossierRes
     *
     * @return Patient
     */
    public function setPatDossierRes($patDossierRes = null)
    {
        $this->patDossierRes = $patDossierRes;

        return $this;
    }

    /**
     * Get patDossierRes.
     *
     * @return bool|null
     */
    public function getPatDossierRes()
    {
        return $this->patDossierRes;
    }

    /**
     * Set patActif.
     *
     * @param bool|null $patActif
     *
     * @return Patient
     */
    public function setPatActif($patActif = null)
    {
        $this->patActif = $patActif;

        return $this;
    }

    /**
     * Get patActif.
     *
     * @return bool|null
     */
    public function getPatActif()
    {
        return $this->patActif;
    }

    /**
     * Set patSdf.
     *
     * @param bool|null $patSdf
     *
     * @return Patient
     */
    public function setPatSdf($patSdf = null)
    {
        $this->patSdf = $patSdf;

        return $this;
    }

    /**
     * Get patSdf.
     *
     * @return bool|null
     */
    public function getPatSdf()
    {
        return $this->patSdf;
    }

    /**
     * Set patNbEnf.
     *
     * @param int|null $patNbEnf
     *
     * @return Patient
     */
    public function setPatNbEnf($patNbEnf = null)
    {
        $this->patNbEnf = $patNbEnf;

        return $this;
    }

    /**
     * Get patNbEnf.
     *
     * @return int|null
     */
    public function getPatNbEnf()
    {
        return $this->patNbEnf;
    }

    /**
     * Set patCodeAccess.
     *
     * @param int|null $patCodeAccess
     *
     * @return Patient
     */
    public function setPatCodeAccess($patCodeAccess = null)
    {
        $this->patCodeAccess = $patCodeAccess;

        return $this;
    }

    /**
     * Get patCodeAccess.
     *
     * @return int|null
     */
    public function getPatCodeAccess()
    {
        return $this->patCodeAccess;
    }

    /**
     * Set perCode.
     *
     * @param \RAN\Entity\Personne $perCode
     *
     * @return Patient
     */
    public function setPerCode(\RAN\Entity\Personne $perCode)
    {
        $this->perCode = $perCode;

        return $this;
    }

    /**
     * Get perCode.
     *
     * @return \RAN\Entity\Personne
     */
    public function getPerCode()
    {
        return $this->perCode;
    }

    /**
     * Set cdiCode.
     *
     * @param \RAN\Entity\CentreDialyse|null $cdiCode
     *
     * @return Patient
     */
    public function setCdiCode(\RAN\Entity\CentreDialyse $cdiCode = null)
    {
        $this->cdiCode = $cdiCode;

        return $this;
    }

    /**
     * Get cdiCode.
     *
     * @return \RAN\Entity\CentreDialyse|null
     */
    public function getCdiCode()
    {
        return $this->cdiCode;
    }

    /**
     * Set sifCode.
     *
     * @param \RAN\Entity\SituationFamiliale|null $sifCode
     *
     * @return Patient
     */
    public function setSifCode(\RAN\Entity\SituationFamiliale $sifCode = null)
    {
        $this->sifCode = $sifCode;

        return $this;
    }

    /**
     * Get sifCode.
     *
     * @return \RAN\Entity\SituationFamiliale|null
     */
    public function getSifCode()
    {
        return $this->sifCode;
    }

    /**
     * Add mreCode.
     *
     * @param \RAN\Entity\EtpMotifRefus $mreCode
     *
     * @return Patient
     */
    public function addMreCode(\RAN\Entity\EtpMotifRefus $mreCode)
    {
        $this->mreCode[] = $mreCode;

        return $this;
    }

    /**
     * Remove mreCode.
     *
     * @param \RAN\Entity\EtpMotifRefus $mreCode
     *
     * @return boolean TRUE if this collection contained the specified element, FALSE otherwise.
     */
    public function removeMreCode(\RAN\Entity\EtpMotifRefus $mreCode)
    {
        return $this->mreCode->removeElement($mreCode);
    }

    /**
     * Get mreCode.
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getMreCode()
    {
        return $this->mreCode;
    }

    /**
     * Add prtCode.
     *
     * @param \RAN\Entity\Protocole $prtCode
     *
     * @return Patient
     */
    public function addPrtCode(\RAN\Entity\Protocole $prtCode)
    {
        $this->prtCode[] = $prtCode;

        return $this;
    }

    /**
     * Remove prtCode.
     *
     * @param \RAN\Entity\Protocole $prtCode
     *
     * @return boolean TRUE if this collection contained the specified element, FALSE otherwise.
     */
    public function removePrtCode(\RAN\Entity\Protocole $prtCode)
    {
        return $this->prtCode->removeElement($prtCode);
    }

    /**
     * Get prtCode.
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getPrtCode()
    {
        return $this->prtCode;
    }
}
