<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * PatientComment
 *
 * @ORM\Table(name="patient_comment")
 * @ORM\Entity
 */
class PatientComment
{
    /**
     * @var int
     *
     * @ORM\Column(name="pat_com", type="integer", nullable=false, options={"unsigned"=true})
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $patCom;

    /**
     * @var int
     *
     * @ORM\Column(name="per_code_pat", type="integer", nullable=false, options={"unsigned"=true})
     */
    private $perCodePat;

    /**
     * @var int
     *
     * @ORM\Column(name="pat_com_type", type="smallint", nullable=false, options={"unsigned"=true})
     */
    private $patComType;

    /**
     * @var string|null
     *
     * @ORM\Column(name="pat_com_txt", type="text", length=65535, nullable=true)
     */
    private $patComTxt;



    /**
     * Get patCom.
     *
     * @return int
     */
    public function getPatCom()
    {
        return $this->patCom;
    }

    /**
     * Set perCodePat.
     *
     * @param int $perCodePat
     *
     * @return PatientComment
     */
    public function setPerCodePat($perCodePat)
    {
        $this->perCodePat = $perCodePat;

        return $this;
    }

    /**
     * Get perCodePat.
     *
     * @return int
     */
    public function getPerCodePat()
    {
        return $this->perCodePat;
    }

    /**
     * Set patComType.
     *
     * @param int $patComType
     *
     * @return PatientComment
     */
    public function setPatComType($patComType)
    {
        $this->patComType = $patComType;

        return $this;
    }

    /**
     * Get patComType.
     *
     * @return int
     */
    public function getPatComType()
    {
        return $this->patComType;
    }

    /**
     * Set patComTxt.
     *
     * @param string|null $patComTxt
     *
     * @return PatientComment
     */
    public function setPatComTxt($patComTxt = null)
    {
        $this->patComTxt = $patComTxt;

        return $this;
    }

    /**
     * Get patComTxt.
     *
     * @return string|null
     */
    public function getPatComTxt()
    {
        return $this->patComTxt;
    }
}
