<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * PatientMedecinTrait
 *
 * @ORM\Table(name="patient_medecin_trait", uniqueConstraints={@ORM\UniqueConstraint(name="uni_pmt_code", columns={"per_code_med", "per_code_pat"})}, indexes={@ORM\Index(name="per_code_pat", columns={"per_code_pat"}), @ORM\Index(name="IDX_B23E26F4152F5E2", columns={"per_code_med"})})
 * @ORM\Entity
 */
class PatientMedecinTrait
{
    /**
     * @var int
     *
     * @ORM\Column(name="pmt_code", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $pmtCode;

    /**
     * @var \RAN\Entity\Medecin
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\Medecin")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="per_code_med", referencedColumnName="per_code")
     * })
     */
    private $perCodeMed;

    /**
     * @var \RAN\Entity\Patient
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\Patient")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="per_code_pat", referencedColumnName="per_code")
     * })
     */
    private $perCodePat;



    /**
     * Get pmtCode.
     *
     * @return int
     */
    public function getPmtCode()
    {
        return $this->pmtCode;
    }

    /**
     * Set perCodeMed.
     *
     * @param \RAN\Entity\Medecin|null $perCodeMed
     *
     * @return PatientMedecinTrait
     */
    public function setPerCodeMed(\RAN\Entity\Medecin $perCodeMed = null)
    {
        $this->perCodeMed = $perCodeMed;

        return $this;
    }

    /**
     * Get perCodeMed.
     *
     * @return \RAN\Entity\Medecin|null
     */
    public function getPerCodeMed()
    {
        return $this->perCodeMed;
    }

    /**
     * Set perCodePat.
     *
     * @param \RAN\Entity\Patient|null $perCodePat
     *
     * @return PatientMedecinTrait
     */
    public function setPerCodePat(\RAN\Entity\Patient $perCodePat = null)
    {
        $this->perCodePat = $perCodePat;

        return $this;
    }

    /**
     * Get perCodePat.
     *
     * @return \RAN\Entity\Patient|null
     */
    public function getPerCodePat()
    {
        return $this->perCodePat;
    }
}
