<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * PatientsConsultes
 *
 * @ORM\Table(name="patients_consultes", uniqueConstraints={@ORM\UniqueConstraint(name="uniq_per_pat", columns={"per_code_uti", "per_code_pat"})}, indexes={@ORM\Index(name="fk_fk_patients_consultes_util", columns={"per_code_pat"}), @ORM\Index(name="per_code_pat", columns={"per_code_pat", "pat_uti_ts"}), @ORM\Index(name="per_code_uti", columns={"per_code_uti"})})
 * @ORM\Entity
 */
class PatientsConsultes
{
    /**
     * @var int
     *
     * @ORM\Column(name="perpat_code", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $perpatCode;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="pat_uti_ts", type="datetime", nullable=false, options={"default"="CURRENT_TIMESTAMP"})
     */
    private $patUtiTs = 'CURRENT_TIMESTAMP';

    /**
     * @var \RAN\Entity\Utilisateur
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\Utilisateur")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="per_code_uti", referencedColumnName="per_code_uti")
     * })
     */
    private $perCodeUti;

    /**
     * @var \RAN\Entity\Patient
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\Patient")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="per_code_pat", referencedColumnName="per_code")
     * })
     */
    private $perCodePat;



    /**
     * Get perpatCode.
     *
     * @return int
     */
    public function getPerpatCode()
    {
        return $this->perpatCode;
    }

    /**
     * Set patUtiTs.
     *
     * @param \DateTime $patUtiTs
     *
     * @return PatientsConsultes
     */
    public function setPatUtiTs($patUtiTs)
    {
        $this->patUtiTs = $patUtiTs;

        return $this;
    }

    /**
     * Get patUtiTs.
     *
     * @return \DateTime
     */
    public function getPatUtiTs()
    {
        return $this->patUtiTs;
    }

    /**
     * Set perCodeUti.
     *
     * @param \RAN\Entity\Utilisateur|null $perCodeUti
     *
     * @return PatientsConsultes
     */
    public function setPerCodeUti(\RAN\Entity\Utilisateur $perCodeUti = null)
    {
        $this->perCodeUti = $perCodeUti;

        return $this;
    }

    /**
     * Get perCodeUti.
     *
     * @return \RAN\Entity\Utilisateur|null
     */
    public function getPerCodeUti()
    {
        return $this->perCodeUti;
    }

    /**
     * Set perCodePat.
     *
     * @param \RAN\Entity\Patient|null $perCodePat
     *
     * @return PatientsConsultes
     */
    public function setPerCodePat(\RAN\Entity\Patient $perCodePat = null)
    {
        $this->perCodePat = $perCodePat;

        return $this;
    }

    /**
     * Get perCodePat.
     *
     * @return \RAN\Entity\Patient|null
     */
    public function getPerCodePat()
    {
        return $this->perCodePat;
    }
}
