<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Pays
 *
 * @ORM\Table(name="pays")
 * @ORM\Entity
 */
class Pays
{
    /**
     * @var int
     *
     * @ORM\Column(name="pay_id", type="smallint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $payId;

    /**
     * @var string
     *
     * @ORM\Column(name="pay_nom", type="string", length=50, nullable=false)
     */
    private $payNom;

    /**
     * @var string
     *
     * @ORM\Column(name="pay_code", type="string", length=6, nullable=false)
     */
    private $payCode;



    /**
     * Get payId.
     *
     * @return int
     */
    public function getPayId()
    {
        return $this->payId;
    }

    /**
     * Set payNom.
     *
     * @param string $payNom
     *
     * @return Pays
     */
    public function setPayNom($payNom)
    {
        $this->payNom = $payNom;

        return $this;
    }

    /**
     * Get payNom.
     *
     * @return string
     */
    public function getPayNom()
    {
        return $this->payNom;
    }

    /**
     * Set payCode.
     *
     * @param string $payCode
     *
     * @return Pays
     */
    public function setPayCode($payCode)
    {
        $this->payCode = $payCode;

        return $this;
    }

    /**
     * Get payCode.
     *
     * @return string
     */
    public function getPayCode()
    {
        return $this->payCode;
    }
}
