<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * PenseBeteAllergie
 *
 * @ORM\Table(name="pense_bete_allergie")
 * @ORM\Entity
 */
class PenseBeteAllergie
{
    /**
     * @var \DateTime
     *
     * @ORM\Column(name="pal_dt_creat", type="date", nullable=false)
     */
    private $palDtCreat;

    /**
     * @var string
     *
     * @ORM\Column(name="pal_comment", type="string", length=2000, nullable=false)
     */
    private $palComment;

    /**
     * @var \RAN\Entity\Patient
     *
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     * @ORM\OneToOne(targetEntity="RAN\Entity\Patient")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="per_code", referencedColumnName="per_code")
     * })
     */
    private $perCode;



    /**
     * Set palDtCreat.
     *
     * @param \DateTime $palDtCreat
     *
     * @return PenseBeteAllergie
     */
    public function setPalDtCreat($palDtCreat)
    {
        $this->palDtCreat = $palDtCreat;

        return $this;
    }

    /**
     * Get palDtCreat.
     *
     * @return \DateTime
     */
    public function getPalDtCreat()
    {
        return $this->palDtCreat;
    }

    /**
     * Set palComment.
     *
     * @param string $palComment
     *
     * @return PenseBeteAllergie
     */
    public function setPalComment($palComment)
    {
        $this->palComment = $palComment;

        return $this;
    }

    /**
     * Get palComment.
     *
     * @return string
     */
    public function getPalComment()
    {
        return $this->palComment;
    }

    /**
     * Set perCode.
     *
     * @param \RAN\Entity\Patient $perCode
     *
     * @return PenseBeteAllergie
     */
    public function setPerCode(\RAN\Entity\Patient $perCode)
    {
        $this->perCode = $perCode;

        return $this;
    }

    /**
     * Get perCode.
     *
     * @return \RAN\Entity\Patient
     */
    public function getPerCode()
    {
        return $this->perCode;
    }
}
