<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * PenseBeteAntecedent
 *
 * @ORM\Table(name="pense_bete_antecedent")
 * @ORM\Entity
 */
class PenseBeteAntecedent
{
    /**
     * @var \DateTime
     *
     * @ORM\Column(name="pan_dt_creat", type="date", nullable=false)
     */
    private $panDtCreat;

    /**
     * @var string
     *
     * @ORM\Column(name="pan_comment", type="string", length=2000, nullable=false)
     */
    private $panComment;

    /**
     * @var \RAN\Entity\Patient
     *
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     * @ORM\OneToOne(targetEntity="RAN\Entity\Patient")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="per_code", referencedColumnName="per_code")
     * })
     */
    private $perCode;



    /**
     * Set panDtCreat.
     *
     * @param \DateTime $panDtCreat
     *
     * @return PenseBeteAntecedent
     */
    public function setPanDtCreat($panDtCreat)
    {
        $this->panDtCreat = $panDtCreat;

        return $this;
    }

    /**
     * Get panDtCreat.
     *
     * @return \DateTime
     */
    public function getPanDtCreat()
    {
        return $this->panDtCreat;
    }

    /**
     * Set panComment.
     *
     * @param string $panComment
     *
     * @return PenseBeteAntecedent
     */
    public function setPanComment($panComment)
    {
        $this->panComment = $panComment;

        return $this;
    }

    /**
     * Get panComment.
     *
     * @return string
     */
    public function getPanComment()
    {
        return $this->panComment;
    }

    /**
     * Set perCode.
     *
     * @param \RAN\Entity\Patient $perCode
     *
     * @return PenseBeteAntecedent
     */
    public function setPerCode(\RAN\Entity\Patient $perCode)
    {
        $this->perCode = $perCode;

        return $this;
    }

    /**
     * Get perCode.
     *
     * @return \RAN\Entity\Patient
     */
    public function getPerCode()
    {
        return $this->perCode;
    }
}
