<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Personne
 *
 * @ORM\Table(name="personne", indexes={@ORM\Index(name="fk_fk_personne_civilite", columns={"civ_code"}), @ORM\Index(name="fk_fk_medecin_centre", columns={"cer_code"})})
 * @ORM\Entity
 */
class Personne
{
    /**
     * @var int
     *
     * @ORM\Column(name="per_code", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $perCode;

    /**
     * @var string
     *
     * @ORM\Column(name="per_nom", type="string", length=50, nullable=false)
     */
    private $perNom;

    /**
     * @var string
     *
     * @ORM\Column(name="per_prenom", type="string", length=50, nullable=false)
     */
    private $perPrenom;

    /**
     * @var \RAN\Entity\CentreDeRattachement
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\CentreDeRattachement")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="cer_code", referencedColumnName="cer_code")
     * })
     */
    private $cerCode;

    /**
     * @var \RAN\Entity\Civilite
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\Civilite")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="civ_code", referencedColumnName="civ_code")
     * })
     */
    private $civCode;

    /**
     * @var \Doctrine\Common\Collections\Collection
     *
     * @ORM\ManyToMany(targetEntity="RAN\Entity\AdressePostale", mappedBy="perCode")
     */
    private $adrCode;

    /**
     * @var \Doctrine\Common\Collections\Collection
     *
     * @ORM\ManyToMany(targetEntity="RAN\Entity\Email", inversedBy="perCode")
     * @ORM\JoinTable(name="personne_email",
     *   joinColumns={
     *     @ORM\JoinColumn(name="per_code", referencedColumnName="per_code")
     *   },
     *   inverseJoinColumns={
     *     @ORM\JoinColumn(name="ema_code", referencedColumnName="EMA_CODE")
     *   }
     * )
     */
    private $emaCode;
    
    /**
     * @var \Doctrine\Common\Collections\Collection
     *
     * @ORM\OneToMany(targetEntity="RAN\Entity\PersonneTelephone", mappedBy="perCode")
     */
    private $perTel;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->adrCode = new \Doctrine\Common\Collections\ArrayCollection();
        $this->emaCode = new \Doctrine\Common\Collections\ArrayCollection();
    }


    /**
     * Get perCode.
     *
     * @return int
     */
    public function getPerCode()
    {
        return $this->perCode;
    }

    /**
     * Set perNom.
     *
     * @param string $perNom
     *
     * @return Personne
     */
    public function setPerNom($perNom)
    {
        $this->perNom = $perNom;

        return $this;
    }

    /**
     * Get perNom.
     *
     * @return string
     */
    public function getPerNom()
    {
        return $this->perNom;
    }

    /**
     * Set perPrenom.
     *
     * @param string $perPrenom
     *
     * @return Personne
     */
    public function setPerPrenom($perPrenom)
    {
        $this->perPrenom = $perPrenom;

        return $this;
    }

    /**
     * Get perPrenom.
     *
     * @return string
     */
    public function getPerPrenom()
    {
        return $this->perPrenom;
    }

    /**
     * Set cerCode.
     *
     * @param \RAN\Entity\CentreDeRattachement|null $cerCode
     *
     * @return Personne
     */
    public function setCerCode(\RAN\Entity\CentreDeRattachement $cerCode = null)
    {
        $this->cerCode = $cerCode;

        return $this;
    }

    /**
     * Get cerCode.
     *
     * @return \RAN\Entity\CentreDeRattachement|null
     */
    public function getCerCode()
    {
        return $this->cerCode;
    }

    /**
     * Set civCode.
     *
     * @param \RAN\Entity\Civilite|null $civCode
     *
     * @return Personne
     */
    public function setCivCode(\RAN\Entity\Civilite $civCode = null)
    {
        $this->civCode = $civCode;

        return $this;
    }

    /**
     * Get civCode.
     *
     * @return \RAN\Entity\Civilite|null
     */
    public function getCivCode()
    {
        return $this->civCode;
    }

    /**
     * Add adrCode.
     *
     * @param \RAN\Entity\AdressePostale $adrCode
     *
     * @return Personne
     */
    public function addAdrCode(\RAN\Entity\AdressePostale $adrCode)
    {
        $this->adrCode[] = $adrCode;

        return $this;
    }

    /**
     * Remove adrCode.
     *
     * @param \RAN\Entity\AdressePostale $adrCode
     *
     * @return boolean TRUE if this collection contained the specified element, FALSE otherwise.
     */
    public function removeAdrCode(\RAN\Entity\AdressePostale $adrCode)
    {
        return $this->adrCode->removeElement($adrCode);
    }

    /**
     * Get adrCode.
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getAdrCode()
    {
        return $this->adrCode;
    }

    /**
     * Add emaCode.
     *
     * @param \RAN\Entity\Email $emaCode
     *
     * @return Personne
     */
    public function addEmaCode(\RAN\Entity\Email $emaCode)
    {
        $this->emaCode[] = $emaCode;

        return $this;
    }

    /**
     * Remove emaCode.
     *
     * @param \RAN\Entity\Email $emaCode
     *
     * @return boolean TRUE if this collection contained the specified element, FALSE otherwise.
     */
    public function removeEmaCode(\RAN\Entity\Email $emaCode)
    {
        return $this->emaCode->removeElement($emaCode);
    }

    /**
     * Get emaCode.
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getEmaCode()
    {
        return $this->emaCode;
    }

    /**
     * Add perTel.
     *
     * @param \RAN\Entity\PersonneTelephone $perTel
     *
     * @return Personne
     */
    public function addPerTel(\RAN\Entity\PersonneTelephone $perTel)
    {
        $this->perTel[] = $perTel;

        return $this;
    }

    /**
     * Remove perTel.
     *
     * @param \RAN\Entity\PersonneTelephone $perTel
     *
     * @return boolean TRUE if this collection contained the specified element, FALSE otherwise.
     */
    public function removePerTel(\RAN\Entity\PersonneTelephone $perTel)
    {
        return $this->perTel->removeElement($perTel);
    }

    /**
     * Get perTel.
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getPerTel()
    {
        return $this->perTel;
    }
}
