<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * PersonneTelephone
 *
 * @ORM\Table(name="personne_telephone", uniqueConstraints={@ORM\UniqueConstraint(name="uniq_per_tel", columns={"per_code", "tel_code"})}, indexes={@ORM\Index(name="fk_personne_telephone_per", columns={"per_code"}), @ORM\Index(name="fk_personne_telephone_telephone", columns={"tel_code"})})
 * @ORM\Entity
 */
class PersonneTelephone
{
    /**
     * @var int
     *
     * @ORM\Column(name="pertel_code", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $pertelCode;

    /**
     * @var string|null
     *
     * @ORM\Column(name="per_tel_commentaire", type="string", length=200, nullable=true)
     */
    private $perTelCommentaire;

    /**
     * @var \RAN\Entity\Personne
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\Personne")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="per_code", referencedColumnName="per_code")
     * })
     */
    private $perCode;

    /**
     * @var \RAN\Entity\Telephone
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\Telephone")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="tel_code", referencedColumnName="tel_code")
     * })
     */
    private $telCode;



    /**
     * Get pertelCode.
     *
     * @return int
     */
    public function getPertelCode()
    {
        return $this->pertelCode;
    }

    /**
     * Set perTelCommentaire.
     *
     * @param string|null $perTelCommentaire
     *
     * @return PersonneTelephone
     */
    public function setPerTelCommentaire($perTelCommentaire = null)
    {
        $this->perTelCommentaire = $perTelCommentaire;

        return $this;
    }

    /**
     * Get perTelCommentaire.
     *
     * @return string|null
     */
    public function getPerTelCommentaire()
    {
        return $this->perTelCommentaire;
    }

    /**
     * Set perCode.
     *
     * @param \RAN\Entity\Personne|null $perCode
     *
     * @return PersonneTelephone
     */
    public function setPerCode(\RAN\Entity\Personne $perCode = null)
    {
        $this->perCode = $perCode;

        return $this;
    }

    /**
     * Get perCode.
     *
     * @return \RAN\Entity\Personne|null
     */
    public function getPerCode()
    {
        return $this->perCode;
    }

    /**
     * Set telCode.
     *
     * @param \RAN\Entity\Telephone|null $telCode
     *
     * @return PersonneTelephone
     */
    public function setTelCode(\RAN\Entity\Telephone $telCode = null)
    {
        $this->telCode = $telCode;

        return $this;
    }

    /**
     * Get telCode.
     *
     * @return \RAN\Entity\Telephone|null
     */
    public function getTelCode()
    {
        return $this->telCode;
    }
}
