<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Prescription
 *
 * @ORM\Table(name="prescription", uniqueConstraints={@ORM\UniqueConstraint(name="uniq_pre_code", columns={"ord_code", "medi_code"})}, indexes={@ORM\Index(name="PRESCRIPTION_MEDIC", columns={"medi_code"}), @ORM\Index(name="IDX_1FBFB8D9686956AE", columns={"ord_code"})})
 * @ORM\Entity
 */
class Prescription
{
    /**
     * @var int
     *
     * @ORM\Column(name="pre_code", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $preCode;

    /**
     * @var int
     *
     * @ORM\Column(name="pro_code", type="smallint", nullable=false)
     */
    private $proCode;

    /**
     * @var string|null
     *
     * @ORM\Column(name="pre_quantite", type="string", length=255, nullable=true)
     */
    private $preQuantite;

    /**
     * @var int|null
     *
     * @ORM\Column(name="pre_duree", type="smallint", nullable=true)
     */
    private $preDuree;

    /**
     * @var int|null
     *
     * @ORM\Column(name="pre_renouvel", type="smallint", nullable=true)
     */
    private $preRenouvel;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="pre_dt_arret", type="date", nullable=true)
     */
    private $preDtArret;

    /**
     * @var int|null
     *
     * @ORM\Column(name="pre_bizone", type="smallint", nullable=true)
     */
    private $preBizone;

    /**
     * @var string|null
     *
     * @ORM\Column(name="pre_duree_type", type="string", length=1, nullable=true, options={"fixed"=true})
     */
    private $preDureeType;

    /**
     * @var bool
     *
     * @ORM\Column(name="pre_access", type="boolean", nullable=false)
     */
    private $preAccess = '0';

    /**
     * @var string|null
     *
     * @ORM\Column(name="pre_quantite_access", type="string", length=50, nullable=true)
     */
    private $preQuantiteAccess;

    /**
     * @var string|null
     *
     * @ORM\Column(name="pre_renouvel_access", type="string", length=50, nullable=true)
     */
    private $preRenouvelAccess;

    /**
     * @var string|null
     *
     * @ORM\Column(name="pre_duree_access", type="string", length=50, nullable=true)
     */
    private $preDureeAccess;

    /**
     * @var bool
     *
     * @ORM\Column(name="pre_non_substituable", type="boolean", nullable=false)
     */
    private $preNonSubstituable = '0';

    /**
     * @var \RAN\Entity\Medicament
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\Medicament")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="medi_code", referencedColumnName="medi_code")
     * })
     */
    private $mediCode;

    /**
     * @var \RAN\Entity\Ordonnance
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\Ordonnance")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="ord_code", referencedColumnName="ord_code")
     * })
     */
    private $ordCode;



    /**
     * Get preCode.
     *
     * @return int
     */
    public function getPreCode()
    {
        return $this->preCode;
    }

    /**
     * Set proCode.
     *
     * @param int $proCode
     *
     * @return Prescription
     */
    public function setProCode($proCode)
    {
        $this->proCode = $proCode;

        return $this;
    }

    /**
     * Get proCode.
     *
     * @return int
     */
    public function getProCode()
    {
        return $this->proCode;
    }

    /**
     * Set preQuantite.
     *
     * @param string|null $preQuantite
     *
     * @return Prescription
     */
    public function setPreQuantite($preQuantite = null)
    {
        $this->preQuantite = $preQuantite;

        return $this;
    }

    /**
     * Get preQuantite.
     *
     * @return string|null
     */
    public function getPreQuantite()
    {
        return $this->preQuantite;
    }

    /**
     * Set preDuree.
     *
     * @param int|null $preDuree
     *
     * @return Prescription
     */
    public function setPreDuree($preDuree = null)
    {
        $this->preDuree = $preDuree;

        return $this;
    }

    /**
     * Get preDuree.
     *
     * @return int|null
     */
    public function getPreDuree()
    {
        return $this->preDuree;
    }

    /**
     * Set preRenouvel.
     *
     * @param int|null $preRenouvel
     *
     * @return Prescription
     */
    public function setPreRenouvel($preRenouvel = null)
    {
        $this->preRenouvel = $preRenouvel;

        return $this;
    }

    /**
     * Get preRenouvel.
     *
     * @return int|null
     */
    public function getPreRenouvel()
    {
        return $this->preRenouvel;
    }

    /**
     * Set preDtArret.
     *
     * @param \DateTime|null $preDtArret
     *
     * @return Prescription
     */
    public function setPreDtArret($preDtArret = null)
    {
        $this->preDtArret = $preDtArret;

        return $this;
    }

    /**
     * Get preDtArret.
     *
     * @return \DateTime|null
     */
    public function getPreDtArret()
    {
        return $this->preDtArret;
    }

    /**
     * Set preBizone.
     *
     * @param int|null $preBizone
     *
     * @return Prescription
     */
    public function setPreBizone($preBizone = null)
    {
        $this->preBizone = $preBizone;

        return $this;
    }

    /**
     * Get preBizone.
     *
     * @return int|null
     */
    public function getPreBizone()
    {
        return $this->preBizone;
    }

    /**
     * Set preDureeType.
     *
     * @param string|null $preDureeType
     *
     * @return Prescription
     */
    public function setPreDureeType($preDureeType = null)
    {
        $this->preDureeType = $preDureeType;

        return $this;
    }

    /**
     * Get preDureeType.
     *
     * @return string|null
     */
    public function getPreDureeType()
    {
        return $this->preDureeType;
    }

    /**
     * Set preAccess.
     *
     * @param bool $preAccess
     *
     * @return Prescription
     */
    public function setPreAccess($preAccess)
    {
        $this->preAccess = $preAccess;

        return $this;
    }

    /**
     * Get preAccess.
     *
     * @return bool
     */
    public function getPreAccess()
    {
        return $this->preAccess;
    }

    /**
     * Set preQuantiteAccess.
     *
     * @param string|null $preQuantiteAccess
     *
     * @return Prescription
     */
    public function setPreQuantiteAccess($preQuantiteAccess = null)
    {
        $this->preQuantiteAccess = $preQuantiteAccess;

        return $this;
    }

    /**
     * Get preQuantiteAccess.
     *
     * @return string|null
     */
    public function getPreQuantiteAccess()
    {
        return $this->preQuantiteAccess;
    }

    /**
     * Set preRenouvelAccess.
     *
     * @param string|null $preRenouvelAccess
     *
     * @return Prescription
     */
    public function setPreRenouvelAccess($preRenouvelAccess = null)
    {
        $this->preRenouvelAccess = $preRenouvelAccess;

        return $this;
    }

    /**
     * Get preRenouvelAccess.
     *
     * @return string|null
     */
    public function getPreRenouvelAccess()
    {
        return $this->preRenouvelAccess;
    }

    /**
     * Set preDureeAccess.
     *
     * @param string|null $preDureeAccess
     *
     * @return Prescription
     */
    public function setPreDureeAccess($preDureeAccess = null)
    {
        $this->preDureeAccess = $preDureeAccess;

        return $this;
    }

    /**
     * Get preDureeAccess.
     *
     * @return string|null
     */
    public function getPreDureeAccess()
    {
        return $this->preDureeAccess;
    }

    /**
     * Set preNonSubstituable.
     *
     * @param bool $preNonSubstituable
     *
     * @return Prescription
     */
    public function setPreNonSubstituable($preNonSubstituable)
    {
        $this->preNonSubstituable = $preNonSubstituable;

        return $this;
    }

    /**
     * Get preNonSubstituable.
     *
     * @return bool
     */
    public function getPreNonSubstituable()
    {
        return $this->preNonSubstituable;
    }

    /**
     * Set mediCode.
     *
     * @param \RAN\Entity\Medicament|null $mediCode
     *
     * @return Prescription
     */
    public function setMediCode(\RAN\Entity\Medicament $mediCode = null)
    {
        $this->mediCode = $mediCode;

        return $this;
    }

    /**
     * Get mediCode.
     *
     * @return \RAN\Entity\Medicament|null
     */
    public function getMediCode()
    {
        return $this->mediCode;
    }

    /**
     * Set ordCode.
     *
     * @param \RAN\Entity\Ordonnance|null $ordCode
     *
     * @return Prescription
     */
    public function setOrdCode(\RAN\Entity\Ordonnance $ordCode = null)
    {
        $this->ordCode = $ordCode;

        return $this;
    }

    /**
     * Get ordCode.
     *
     * @return \RAN\Entity\Ordonnance|null
     */
    public function getOrdCode()
    {
        return $this->ordCode;
    }
}
