<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ProfilConsultation
 *
 * @ORM\Table(name="profil_consultation")
 * @ORM\Entity
 */
class ProfilConsultation
{
    /**
     * @var int
     *
     * @ORM\Column(name="prc_code", type="smallint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $prcCode;

    /**
     * @var string
     *
     * @ORM\Column(name="prc_desc", type="string", length=50, nullable=false)
     */
    private $prcDesc;

    /**
     * @var bool
     *
     * @ORM\Column(name="prc_archive", type="boolean", nullable=false)
     */
    private $prcArchive = '0';



    /**
     * Get prcCode.
     *
     * @return int
     */
    public function getPrcCode()
    {
        return $this->prcCode;
    }

    /**
     * Set prcDesc.
     *
     * @param string $prcDesc
     *
     * @return ProfilConsultation
     */
    public function setPrcDesc($prcDesc)
    {
        $this->prcDesc = $prcDesc;

        return $this;
    }

    /**
     * Get prcDesc.
     *
     * @return string
     */
    public function getPrcDesc()
    {
        return $this->prcDesc;
    }

    /**
     * Set prcArchive.
     *
     * @param bool $prcArchive
     *
     * @return ProfilConsultation
     */
    public function setPrcArchive($prcArchive)
    {
        $this->prcArchive = $prcArchive;

        return $this;
    }

    /**
     * Get prcArchive.
     *
     * @return bool
     */
    public function getPrcArchive()
    {
        return $this->prcArchive;
    }
}
