<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ProfilCsParamBio
 *
 * @ORM\Table(name="profil_cs_param_bio", uniqueConstraints={@ORM\UniqueConstraint(name="uniq_pbi_prc", columns={"pbi_code", "prc_code"})}, indexes={@ORM\Index(name="fk_fk_profil_cs_param_bio_profil", columns={"prc_code"}), @ORM\Index(name="IDX_F9508F4516B2FA39", columns={"pbi_code"})})
 * @ORM\Entity
 */
class ProfilCsParamBio
{
    /**
     * @var int
     *
     * @ORM\Column(name="prcpbi_code", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $prcpbiCode;

    /**
     * @var int
     *
     * @ORM\Column(name="pcp_ordre", type="integer", nullable=false)
     */
    private $pcpOrdre;

    /**
     * @var \RAN\Entity\ParametresBiologiques
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\ParametresBiologiques")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="pbi_code", referencedColumnName="pbi_code")
     * })
     */
    private $pbiCode;

    /**
     * @var \RAN\Entity\ProfilConsultation
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\ProfilConsultation")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="prc_code", referencedColumnName="prc_code")
     * })
     */
    private $prcCode;



    /**
     * Get prcpbiCode.
     *
     * @return int
     */
    public function getPrcpbiCode()
    {
        return $this->prcpbiCode;
    }

    /**
     * Set pcpOrdre.
     *
     * @param int $pcpOrdre
     *
     * @return ProfilCsParamBio
     */
    public function setPcpOrdre($pcpOrdre)
    {
        $this->pcpOrdre = $pcpOrdre;

        return $this;
    }

    /**
     * Get pcpOrdre.
     *
     * @return int
     */
    public function getPcpOrdre()
    {
        return $this->pcpOrdre;
    }

    /**
     * Set pbiCode.
     *
     * @param \RAN\Entity\ParametresBiologiques|null $pbiCode
     *
     * @return ProfilCsParamBio
     */
    public function setPbiCode(\RAN\Entity\ParametresBiologiques $pbiCode = null)
    {
        $this->pbiCode = $pbiCode;

        return $this;
    }

    /**
     * Get pbiCode.
     *
     * @return \RAN\Entity\ParametresBiologiques|null
     */
    public function getPbiCode()
    {
        return $this->pbiCode;
    }

    /**
     * Set prcCode.
     *
     * @param \RAN\Entity\ProfilConsultation|null $prcCode
     *
     * @return ProfilCsParamBio
     */
    public function setPrcCode(\RAN\Entity\ProfilConsultation $prcCode = null)
    {
        $this->prcCode = $prcCode;

        return $this;
    }

    /**
     * Get prcCode.
     *
     * @return \RAN\Entity\ProfilConsultation|null
     */
    public function getPrcCode()
    {
        return $this->prcCode;
    }
}
