<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Protocole
 *
 * @ORM\Table(name="protocole")
 * @ORM\Entity
 */
class Protocole
{
    /**
     * @var int
     *
     * @ORM\Column(name="prt_code", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $prtCode;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="prt_dt_creat", type="date", nullable=false)
     */
    private $prtDtCreat;

    /**
     * @var string
     *
     * @ORM\Column(name="prt_nom", type="string", length=50, nullable=false)
     */
    private $prtNom;

    /**
     * @var string
     *
     * @ORM\Column(name="prt_comment", type="string", length=500, nullable=false)
     */
    private $prtComment;

    /**
     * @var \Doctrine\Common\Collections\Collection
     *
     * @ORM\ManyToMany(targetEntity="RAN\Entity\Patient", inversedBy="prtCode")
     * @ORM\JoinTable(name="patient_protocole",
     *   joinColumns={
     *     @ORM\JoinColumn(name="prt_code", referencedColumnName="prt_code")
     *   },
     *   inverseJoinColumns={
     *     @ORM\JoinColumn(name="per_code_pat", referencedColumnName="per_code")
     *   }
     * )
     */
    private $perCodePat;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->perCodePat = new \Doctrine\Common\Collections\ArrayCollection();
    }


    /**
     * Get prtCode.
     *
     * @return int
     */
    public function getPrtCode()
    {
        return $this->prtCode;
    }

    /**
     * Set prtDtCreat.
     *
     * @param \DateTime $prtDtCreat
     *
     * @return Protocole
     */
    public function setPrtDtCreat($prtDtCreat)
    {
        $this->prtDtCreat = $prtDtCreat;

        return $this;
    }

    /**
     * Get prtDtCreat.
     *
     * @return \DateTime
     */
    public function getPrtDtCreat()
    {
        return $this->prtDtCreat;
    }

    /**
     * Set prtNom.
     *
     * @param string $prtNom
     *
     * @return Protocole
     */
    public function setPrtNom($prtNom)
    {
        $this->prtNom = $prtNom;

        return $this;
    }

    /**
     * Get prtNom.
     *
     * @return string
     */
    public function getPrtNom()
    {
        return $this->prtNom;
    }

    /**
     * Set prtComment.
     *
     * @param string $prtComment
     *
     * @return Protocole
     */
    public function setPrtComment($prtComment)
    {
        $this->prtComment = $prtComment;

        return $this;
    }

    /**
     * Get prtComment.
     *
     * @return string
     */
    public function getPrtComment()
    {
        return $this->prtComment;
    }

    /**
     * Add perCodePat.
     *
     * @param \RAN\Entity\Patient $perCodePat
     *
     * @return Protocole
     */
    public function addPerCodePat(\RAN\Entity\Patient $perCodePat)
    {
        $this->perCodePat[] = $perCodePat;

        return $this;
    }

    /**
     * Remove perCodePat.
     *
     * @param \RAN\Entity\Patient $perCodePat
     *
     * @return boolean TRUE if this collection contained the specified element, FALSE otherwise.
     */
    public function removePerCodePat(\RAN\Entity\Patient $perCodePat)
    {
        return $this->perCodePat->removeElement($perCodePat);
    }

    /**
     * Get perCodePat.
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getPerCodePat()
    {
        return $this->perCodePat;
    }
}
