<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RisqueImmuno
 *
 * @ORM\Table(name="risque_immuno")
 * @ORM\Entity
 */
class RisqueImmuno
{
    /**
     * @var string
     *
     * @ORM\Column(name="rim_code", type="decimal", precision=1, scale=0, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $rimCode;

    /**
     * @var string
     *
     * @ORM\Column(name="rim_libelle", type="string", length=50, nullable=false)
     */
    private $rimLibelle;



    /**
     * Get rimCode.
     *
     * @return string
     */
    public function getRimCode()
    {
        return $this->rimCode;
    }

    /**
     * Set rimLibelle.
     *
     * @param string $rimLibelle
     *
     * @return RisqueImmuno
     */
    public function setRimLibelle($rimLibelle)
    {
        $this->rimLibelle = $rimLibelle;

        return $this;
    }

    /**
     * Get rimLibelle.
     *
     * @return string
     */
    public function getRimLibelle()
    {
        return $this->rimLibelle;
    }
}
