<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RisqueImmunoAbo
 *
 * @ORM\Table(name="risque_immuno_abo")
 * @ORM\Entity
 */
class RisqueImmunoAbo
{
    /**
     * @var string
     *
     * @ORM\Column(name="rim_abo_code", type="decimal", precision=1, scale=0, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $rimAboCode;

    /**
     * @var string|null
     *
     * @ORM\Column(name="rim_abo_libelle", type="string", length=50, nullable=true)
     */
    private $rimAboLibelle;

    /**
     * @var string|null
     *
     * @ORM\Column(name="rim_abo_ordre", type="decimal", precision=1, scale=0, nullable=true)
     */
    private $rimAboOrdre;



    /**
     * Get rimAboCode.
     *
     * @return string
     */
    public function getRimAboCode()
    {
        return $this->rimAboCode;
    }

    /**
     * Set rimAboLibelle.
     *
     * @param string|null $rimAboLibelle
     *
     * @return RisqueImmunoAbo
     */
    public function setRimAboLibelle($rimAboLibelle = null)
    {
        $this->rimAboLibelle = $rimAboLibelle;

        return $this;
    }

    /**
     * Get rimAboLibelle.
     *
     * @return string|null
     */
    public function getRimAboLibelle()
    {
        return $this->rimAboLibelle;
    }

    /**
     * Set rimAboOrdre.
     *
     * @param string|null $rimAboOrdre
     *
     * @return RisqueImmunoAbo
     */
    public function setRimAboOrdre($rimAboOrdre = null)
    {
        $this->rimAboOrdre = $rimAboOrdre;

        return $this;
    }

    /**
     * Get rimAboOrdre.
     *
     * @return string|null
     */
    public function getRimAboOrdre()
    {
        return $this->rimAboOrdre;
    }
}
