<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RisqueImmunoHla
 *
 * @ORM\Table(name="risque_immuno_hla")
 * @ORM\Entity
 */
class RisqueImmunoHla
{
    /**
     * @var string
     *
     * @ORM\Column(name="rim_hla_code", type="decimal", precision=1, scale=0, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $rimHlaCode;

    /**
     * @var string
     *
     * @ORM\Column(name="rim_hla_libelle", type="string", length=50, nullable=false)
     */
    private $rimHlaLibelle;

    /**
     * @var string
     *
     * @ORM\Column(name="rim_hla_ordre", type="decimal", precision=1, scale=0, nullable=false)
     */
    private $rimHlaOrdre;



    /**
     * Get rimHlaCode.
     *
     * @return string
     */
    public function getRimHlaCode()
    {
        return $this->rimHlaCode;
    }

    /**
     * Set rimHlaLibelle.
     *
     * @param string $rimHlaLibelle
     *
     * @return RisqueImmunoHla
     */
    public function setRimHlaLibelle($rimHlaLibelle)
    {
        $this->rimHlaLibelle = $rimHlaLibelle;

        return $this;
    }

    /**
     * Get rimHlaLibelle.
     *
     * @return string
     */
    public function getRimHlaLibelle()
    {
        return $this->rimHlaLibelle;
    }

    /**
     * Set rimHlaOrdre.
     *
     * @param string $rimHlaOrdre
     *
     * @return RisqueImmunoHla
     */
    public function setRimHlaOrdre($rimHlaOrdre)
    {
        $this->rimHlaOrdre = $rimHlaOrdre;

        return $this;
    }

    /**
     * Get rimHlaOrdre.
     *
     * @return string
     */
    public function getRimHlaOrdre()
    {
        return $this->rimHlaOrdre;
    }
}
