<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Role
 *
 * @ORM\Table(name="role")
 * @ORM\Entity
 */
class Role
{
    /**
     * @var int
     *
     * @ORM\Column(name="rol_code", type="smallint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $rolCode;

    /**
     * @var string
     *
     * @ORM\Column(name="rol_libelle", type="string", length=50, nullable=false)
     */
    private $rolLibelle;

    /**
     * @var int
     *
     * @ORM\Column(name="rol_ordre", type="integer", nullable=false)
     */
    private $rolOrdre;



    /**
     * Get rolCode.
     *
     * @return int
     */
    public function getRolCode()
    {
        return $this->rolCode;
    }

    /**
     * Set rolLibelle.
     *
     * @param string $rolLibelle
     *
     * @return Role
     */
    public function setRolLibelle($rolLibelle)
    {
        $this->rolLibelle = $rolLibelle;

        return $this;
    }

    /**
     * Get rolLibelle.
     *
     * @return string
     */
    public function getRolLibelle()
    {
        return $this->rolLibelle;
    }

    /**
     * Set rolOrdre.
     *
     * @param int $rolOrdre
     *
     * @return Role
     */
    public function setRolOrdre($rolOrdre)
    {
        $this->rolOrdre = $rolOrdre;

        return $this;
    }

    /**
     * Get rolOrdre.
     *
     * @return int
     */
    public function getRolOrdre()
    {
        return $this->rolOrdre;
    }
}
