<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Serologie
 *
 * @ORM\Table(name="serologie")
 * @ORM\Entity
 */
class Serologie
{
    /**
     * @var string
     *
     * @ORM\Column(name="ser_code", type="decimal", precision=2, scale=0, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $serCode;

    /**
     * @var string
     *
     * @ORM\Column(name="ser_libelle", type="string", length=20, nullable=false)
     */
    private $serLibelle;

    /**
     * @var string
     *
     * @ORM\Column(name="ser_ordre", type="decimal", precision=2, scale=0, nullable=false)
     */
    private $serOrdre;



    /**
     * Get serCode.
     *
     * @return string
     */
    public function getSerCode()
    {
        return $this->serCode;
    }

    /**
     * Set serLibelle.
     *
     * @param string $serLibelle
     *
     * @return Serologie
     */
    public function setSerLibelle($serLibelle)
    {
        $this->serLibelle = $serLibelle;

        return $this;
    }

    /**
     * Get serLibelle.
     *
     * @return string
     */
    public function getSerLibelle()
    {
        return $this->serLibelle;
    }

    /**
     * Set serOrdre.
     *
     * @param string $serOrdre
     *
     * @return Serologie
     */
    public function setSerOrdre($serOrdre)
    {
        $this->serOrdre = $serOrdre;

        return $this;
    }

    /**
     * Get serOrdre.
     *
     * @return string
     */
    public function getSerOrdre()
    {
        return $this->serOrdre;
    }
}
