<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * SpecialiteMedicale
 *
 * @ORM\Table(name="specialite_medicale")
 * @ORM\Entity
 */
class SpecialiteMedicale
{
    /**
     * @var int
     *
     * @ORM\Column(name="spm_code", type="smallint", nullable=false, options={"unsigned"=true})
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $spmCode;

    /**
     * @var string
     *
     * @ORM\Column(name="spm_libelle", type="string", length=50, nullable=false)
     */
    private $spmLibelle;



    /**
     * Get spmCode.
     *
     * @return int
     */
    public function getSpmCode()
    {
        return $this->spmCode;
    }

    /**
     * Set spmLibelle.
     *
     * @param string $spmLibelle
     *
     * @return SpecialiteMedicale
     */
    public function setSpmLibelle($spmLibelle)
    {
        $this->spmLibelle = $spmLibelle;

        return $this;
    }

    /**
     * Get spmLibelle.
     *
     * @return string
     */
    public function getSpmLibelle()
    {
        return $this->spmLibelle;
    }
}
