<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * StatutSerologie
 *
 * @ORM\Table(name="statut_serologie")
 * @ORM\Entity
 */
class StatutSerologie
{
    /**
     * @var string
     *
     * @ORM\Column(name="sts_code", type="decimal", precision=2, scale=0, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $stsCode;

    /**
     * @var string
     *
     * @ORM\Column(name="sts_libelle", type="string", length=50, nullable=false)
     */
    private $stsLibelle;

    /**
     * @var string
     *
     * @ORM\Column(name="sts_ordre", type="decimal", precision=2, scale=0, nullable=false)
     */
    private $stsOrdre;



    /**
     * Get stsCode.
     *
     * @return string
     */
    public function getStsCode()
    {
        return $this->stsCode;
    }

    /**
     * Set stsLibelle.
     *
     * @param string $stsLibelle
     *
     * @return StatutSerologie
     */
    public function setStsLibelle($stsLibelle)
    {
        $this->stsLibelle = $stsLibelle;

        return $this;
    }

    /**
     * Get stsLibelle.
     *
     * @return string
     */
    public function getStsLibelle()
    {
        return $this->stsLibelle;
    }

    /**
     * Set stsOrdre.
     *
     * @param string $stsOrdre
     *
     * @return StatutSerologie
     */
    public function setStsOrdre($stsOrdre)
    {
        $this->stsOrdre = $stsOrdre;

        return $this;
    }

    /**
     * Get stsOrdre.
     *
     * @return string
     */
    public function getStsOrdre()
    {
        return $this->stsOrdre;
    }
}
