<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * StatutVirologique
 *
 * @ORM\Table(name="statut_virologique")
 * @ORM\Entity
 */
class StatutVirologique
{
    /**
     * @var string
     *
     * @ORM\Column(name="svi_code", type="decimal", precision=2, scale=0, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $sviCode;

    /**
     * @var string
     *
     * @ORM\Column(name="svi_libelle", type="string", length=20, nullable=false)
     */
    private $sviLibelle;

    /**
     * @var string
     *
     * @ORM\Column(name="svi_ordre", type="decimal", precision=2, scale=0, nullable=false)
     */
    private $sviOrdre;



    /**
     * Get sviCode.
     *
     * @return string
     */
    public function getSviCode()
    {
        return $this->sviCode;
    }

    /**
     * Set sviLibelle.
     *
     * @param string $sviLibelle
     *
     * @return StatutVirologique
     */
    public function setSviLibelle($sviLibelle)
    {
        $this->sviLibelle = $sviLibelle;

        return $this;
    }

    /**
     * Get sviLibelle.
     *
     * @return string
     */
    public function getSviLibelle()
    {
        return $this->sviLibelle;
    }

    /**
     * Set sviOrdre.
     *
     * @param string $sviOrdre
     *
     * @return StatutVirologique
     */
    public function setSviOrdre($sviOrdre)
    {
        $this->sviOrdre = $sviOrdre;

        return $this;
    }

    /**
     * Get sviOrdre.
     *
     * @return string
     */
    public function getSviOrdre()
    {
        return $this->sviOrdre;
    }
}
