<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * TdmIliaques
 *
 * @ORM\Table(name="tdm_iliaques")
 * @ORM\Entity
 */
class TdmIliaques
{
    /**
     * @var string|null
     *
     * @ORM\Column(name="tdi_comment", type="string", length=500, nullable=true)
     */
    private $tdiComment;

    /**
     * @var \RAN\Entity\AntecedentNeoplasique
     *
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     * @ORM\OneToOne(targetEntity="RAN\Entity\AntecedentNeoplasique")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="ant_code", referencedColumnName="ant_code")
     * })
     */
    private $antCode;



    /**
     * Set tdiComment.
     *
     * @param string|null $tdiComment
     *
     * @return TdmIliaques
     */
    public function setTdiComment($tdiComment = null)
    {
        $this->tdiComment = $tdiComment;

        return $this;
    }

    /**
     * Get tdiComment.
     *
     * @return string|null
     */
    public function getTdiComment()
    {
        return $this->tdiComment;
    }

    /**
     * Set antCode.
     *
     * @param \RAN\Entity\AntecedentNeoplasique $antCode
     *
     * @return TdmIliaques
     */
    public function setAntCode(\RAN\Entity\AntecedentNeoplasique $antCode)
    {
        $this->antCode = $antCode;

        return $this;
    }

    /**
     * Get antCode.
     *
     * @return \RAN\Entity\AntecedentNeoplasique
     */
    public function getAntCode()
    {
        return $this->antCode;
    }
}
