<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Telephone
 *
 * @ORM\Table(name="telephone", indexes={@ORM\Index(name="FK_TELEPHONE_TYPE_TELEPHONE", columns={"tyt_code"})})
 * @ORM\Entity
 */
class Telephone
{
    /**
     * @var int
     *
     * @ORM\Column(name="tel_code", type="smallint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $telCode;

    /**
     * @var string
     *
     * @ORM\Column(name="tel_numero", type="string", length=15, nullable=false)
     */
    private $telNumero;

    /**
     * @var \RAN\Entity\TypeTelephone
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\TypeTelephone")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="tyt_code", referencedColumnName="tyt_code")
     * })
     */
    private $tytCode;

    /**
     * @var \Doctrine\Common\Collections\Collection
     *
     * @ORM\ManyToMany(targetEntity="RAN\Entity\CentreDeRattachement", mappedBy="telCode")
     */
    private $cerCode;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->cerCode = new \Doctrine\Common\Collections\ArrayCollection();
    }


    /**
     * Get telCode.
     *
     * @return int
     */
    public function getTelCode()
    {
        return $this->telCode;
    }

    /**
     * Set telNumero.
     *
     * @param string $telNumero
     *
     * @return Telephone
     */
    public function setTelNumero($telNumero)
    {
        $this->telNumero = $telNumero;

        return $this;
    }

    /**
     * Get telNumero.
     *
     * @return string
     */
    public function getTelNumero()
    {
        return $this->telNumero;
    }

    /**
     * Set tytCode.
     *
     * @param \RAN\Entity\TypeTelephone|null $tytCode
     *
     * @return Telephone
     */
    public function setTytCode(\RAN\Entity\TypeTelephone $tytCode = null)
    {
        $this->tytCode = $tytCode;

        return $this;
    }

    /**
     * Get tytCode.
     *
     * @return \RAN\Entity\TypeTelephone|null
     */
    public function getTytCode()
    {
        return $this->tytCode;
    }

    /**
     * Add cerCode.
     *
     * @param \RAN\Entity\CentreDeRattachement $cerCode
     *
     * @return Telephone
     */
    public function addCerCode(\RAN\Entity\CentreDeRattachement $cerCode)
    {
        $this->cerCode[] = $cerCode;

        return $this;
    }

    /**
     * Remove cerCode.
     *
     * @param \RAN\Entity\CentreDeRattachement $cerCode
     *
     * @return boolean TRUE if this collection contained the specified element, FALSE otherwise.
     */
    public function removeCerCode(\RAN\Entity\CentreDeRattachement $cerCode)
    {
        return $this->cerCode->removeElement($cerCode);
    }

    /**
     * Get cerCode.
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getCerCode()
    {
        return $this->cerCode;
    }
}
