<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * TraitImmuno
 *
 * @ORM\Table(name="trait_immuno")
 * @ORM\Entity
 */
class TraitImmuno
{
    /**
     * @var int
     *
     * @ORM\Column(name="tis_code", type="smallint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $tisCode;

    /**
     * @var string
     *
     * @ORM\Column(name="tis_libelle", type="string", length=50, nullable=false)
     */
    private $tisLibelle;

    /**
     * @var string
     *
     * @ORM\Column(name="tis_desc", type="string", length=500, nullable=false)
     */
    private $tisDesc;



    /**
     * Get tisCode.
     *
     * @return int
     */
    public function getTisCode()
    {
        return $this->tisCode;
    }

    /**
     * Set tisLibelle.
     *
     * @param string $tisLibelle
     *
     * @return TraitImmuno
     */
    public function setTisLibelle($tisLibelle)
    {
        $this->tisLibelle = $tisLibelle;

        return $this;
    }

    /**
     * Get tisLibelle.
     *
     * @return string
     */
    public function getTisLibelle()
    {
        return $this->tisLibelle;
    }

    /**
     * Set tisDesc.
     *
     * @param string $tisDesc
     *
     * @return TraitImmuno
     */
    public function setTisDesc($tisDesc)
    {
        $this->tisDesc = $tisDesc;

        return $this;
    }

    /**
     * Get tisDesc.
     *
     * @return string
     */
    public function getTisDesc()
    {
        return $this->tisDesc;
    }
}
