<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * TypeDonneurDecede
 *
 * @ORM\Table(name="type_donneur_decede")
 * @ORM\Entity
 */
class TypeDonneurDecede
{
    /**
     * @var string
     *
     * @ORM\Column(name="tdd_code", type="decimal", precision=1, scale=0, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $tddCode;

    /**
     * @var string
     *
     * @ORM\Column(name="tdd_libelle", type="string", length=50, nullable=false)
     */
    private $tddLibelle;

    /**
     * @var string
     *
     * @ORM\Column(name="tdd_ordree", type="decimal", precision=1, scale=0, nullable=false)
     */
    private $tddOrdree;



    /**
     * Get tddCode.
     *
     * @return string
     */
    public function getTddCode()
    {
        return $this->tddCode;
    }

    /**
     * Set tddLibelle.
     *
     * @param string $tddLibelle
     *
     * @return TypeDonneurDecede
     */
    public function setTddLibelle($tddLibelle)
    {
        $this->tddLibelle = $tddLibelle;

        return $this;
    }

    /**
     * Get tddLibelle.
     *
     * @return string
     */
    public function getTddLibelle()
    {
        return $this->tddLibelle;
    }

    /**
     * Set tddOrdree.
     *
     * @param string $tddOrdree
     *
     * @return TypeDonneurDecede
     */
    public function setTddOrdree($tddOrdree)
    {
        $this->tddOrdree = $tddOrdree;

        return $this;
    }

    /**
     * Get tddOrdree.
     *
     * @return string
     */
    public function getTddOrdree()
    {
        return $this->tddOrdree;
    }
}
