<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * TypeOrdonnance
 *
 * @ORM\Table(name="type_ordonnance")
 * @ORM\Entity
 */
class TypeOrdonnance
{
    /**
     * @var int
     *
     * @ORM\Column(name="tpo_code", type="smallint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $tpoCode;

    /**
     * @var string
     *
     * @ORM\Column(name="tpo_libelle", type="string", length=50, nullable=false)
     */
    private $tpoLibelle;



    /**
     * Get tpoCode.
     *
     * @return int
     */
    public function getTpoCode()
    {
        return $this->tpoCode;
    }

    /**
     * Set tpoLibelle.
     *
     * @param string $tpoLibelle
     *
     * @return TypeOrdonnance
     */
    public function setTpoLibelle($tpoLibelle)
    {
        $this->tpoLibelle = $tpoLibelle;

        return $this;
    }

    /**
     * Get tpoLibelle.
     *
     * @return string
     */
    public function getTpoLibelle()
    {
        return $this->tpoLibelle;
    }
}
