<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * TypeParametreBiologique
 *
 * @ORM\Table(name="type_parametre_biologique")
 * @ORM\Entity
 */
class TypeParametreBiologique
{
    /**
     * @var int
     *
     * @ORM\Column(name="tpb_code", type="smallint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $tpbCode;

    /**
     * @var string
     *
     * @ORM\Column(name="tpb_libelle", type="string", length=50, nullable=false)
     */
    private $tpbLibelle;

    /**
     * @var int|null
     *
     * @ORM\Column(name="tpb_ordre", type="smallint", nullable=true)
     */
    private $tpbOrdre;



    /**
     * Get tpbCode.
     *
     * @return int
     */
    public function getTpbCode()
    {
        return $this->tpbCode;
    }

    /**
     * Set tpbLibelle.
     *
     * @param string $tpbLibelle
     *
     * @return TypeParametreBiologique
     */
    public function setTpbLibelle($tpbLibelle)
    {
        $this->tpbLibelle = $tpbLibelle;

        return $this;
    }

    /**
     * Get tpbLibelle.
     *
     * @return string
     */
    public function getTpbLibelle()
    {
        return $this->tpbLibelle;
    }

    /**
     * Set tpbOrdre.
     *
     * @param int|null $tpbOrdre
     *
     * @return TypeParametreBiologique
     */
    public function setTpbOrdre($tpbOrdre = null)
    {
        $this->tpbOrdre = $tpbOrdre;

        return $this;
    }

    /**
     * Get tpbOrdre.
     *
     * @return int|null
     */
    public function getTpbOrdre()
    {
        return $this->tpbOrdre;
    }
}
