<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Ucrpm
 *
 * @ORM\Table(name="ucrpm")
 * @ORM\Entity
 */
class Ucrpm
{
    /**
     * @var string|null
     *
     * @ORM\Column(name="ucr_comment", type="string", length=500, nullable=true)
     */
    private $ucrComment;

    /**
     * @var \RAN\Entity\AntCardio
     *
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     * @ORM\OneToOne(targetEntity="RAN\Entity\AntCardio")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="ant_code", referencedColumnName="ant_code")
     * })
     */
    private $antCode;



    /**
     * Set ucrComment.
     *
     * @param string|null $ucrComment
     *
     * @return Ucrpm
     */
    public function setUcrComment($ucrComment = null)
    {
        $this->ucrComment = $ucrComment;

        return $this;
    }

    /**
     * Get ucrComment.
     *
     * @return string|null
     */
    public function getUcrComment()
    {
        return $this->ucrComment;
    }

    /**
     * Set antCode.
     *
     * @param \RAN\Entity\AntCardio $antCode
     *
     * @return Ucrpm
     */
    public function setAntCode(\RAN\Entity\AntCardio $antCode)
    {
        $this->antCode = $antCode;

        return $this;
    }

    /**
     * Get antCode.
     *
     * @return \RAN\Entity\AntCardio
     */
    public function getAntCode()
    {
        return $this->antCode;
    }
}
