<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * UniteParam
 *
 * @ORM\Table(name="unite_param")
 * @ORM\Entity
 */
class UniteParam
{
    /**
     * @var int
     *
     * @ORM\Column(name="upa_code", type="smallint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $upaCode;

    /**
     * @var string
     *
     * @ORM\Column(name="upa_libelle", type="string", length=50, nullable=false)
     */
    private $upaLibelle;



    /**
     * Get upaCode.
     *
     * @return int
     */
    public function getUpaCode()
    {
        return $this->upaCode;
    }

    /**
     * Set upaLibelle.
     *
     * @param string $upaLibelle
     *
     * @return UniteParam
     */
    public function setUpaLibelle($upaLibelle)
    {
        $this->upaLibelle = $upaLibelle;

        return $this;
    }

    /**
     * Get upaLibelle.
     *
     * @return string
     */
    public function getUpaLibelle()
    {
        return $this->upaLibelle;
    }
}
