<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Uright
 *
 * @ORM\Table(name="uright")
 * @ORM\Entity
 */
class Uright
{
    /**
     * @var int
     *
     * @ORM\Column(name="uright_id", type="integer", nullable=false, options={"unsigned"=true})
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $urightId;

    /**
     * @var string
     *
     * @ORM\Column(name="uright_name", type="string", length=50, nullable=false)
     */
    private $urightName = '';

    /**
     * @var string
     *
     * @ORM\Column(name="uright_obj", type="string", length=30, nullable=false)
     */
    private $urightObj = '';

    /**
     * @var string|null
     *
     * @ORM\Column(name="uright_action", type="string", length=30, nullable=true)
     */
    private $urightAction;

    /**
     * @var string|null
     *
     * @ORM\Column(name="uright_act", type="string", length=30, nullable=true)
     */
    private $urightAct;

    /**
     * @var bool
     *
     * @ORM\Column(name="uright_priority", type="boolean", nullable=false)
     */
    private $urightPriority = '0';

    /**
     * @var \Doctrine\Common\Collections\Collection
     *
     * @ORM\ManyToMany(targetEntity="RAN\Entity\User", mappedBy="uright")
     */
    private $user;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->user = new \Doctrine\Common\Collections\ArrayCollection();
    }


    /**
     * Get urightId.
     *
     * @return int
     */
    public function getUrightId()
    {
        return $this->urightId;
    }

    /**
     * Set urightName.
     *
     * @param string $urightName
     *
     * @return Uright
     */
    public function setUrightName($urightName)
    {
        $this->urightName = $urightName;

        return $this;
    }

    /**
     * Get urightName.
     *
     * @return string
     */
    public function getUrightName()
    {
        return $this->urightName;
    }

    /**
     * Set urightObj.
     *
     * @param string $urightObj
     *
     * @return Uright
     */
    public function setUrightObj($urightObj)
    {
        $this->urightObj = $urightObj;

        return $this;
    }

    /**
     * Get urightObj.
     *
     * @return string
     */
    public function getUrightObj()
    {
        return $this->urightObj;
    }

    /**
     * Set urightAction.
     *
     * @param string|null $urightAction
     *
     * @return Uright
     */
    public function setUrightAction($urightAction = null)
    {
        $this->urightAction = $urightAction;

        return $this;
    }

    /**
     * Get urightAction.
     *
     * @return string|null
     */
    public function getUrightAction()
    {
        return $this->urightAction;
    }

    /**
     * Set urightAct.
     *
     * @param string|null $urightAct
     *
     * @return Uright
     */
    public function setUrightAct($urightAct = null)
    {
        $this->urightAct = $urightAct;

        return $this;
    }

    /**
     * Get urightAct.
     *
     * @return string|null
     */
    public function getUrightAct()
    {
        return $this->urightAct;
    }

    /**
     * Set urightPriority.
     *
     * @param bool $urightPriority
     *
     * @return Uright
     */
    public function setUrightPriority($urightPriority)
    {
        $this->urightPriority = $urightPriority;

        return $this;
    }

    /**
     * Get urightPriority.
     *
     * @return bool
     */
    public function getUrightPriority()
    {
        return $this->urightPriority;
    }

    /**
     * Add user.
     *
     * @param \RAN\Entity\User $user
     *
     * @return Uright
     */
    public function addUser(\RAN\Entity\User $user)
    {
        $this->user[] = $user;

        return $this;
    }

    /**
     * Remove user.
     *
     * @param \RAN\Entity\User $user
     *
     * @return boolean TRUE if this collection contained the specified element, FALSE otherwise.
     */
    public function removeUser(\RAN\Entity\User $user)
    {
        return $this->user->removeElement($user);
    }

    /**
     * Get user.
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getUser()
    {
        return $this->user;
    }
}
