<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * User
 *
 * @ORM\Table(name="user", uniqueConstraints={@ORM\UniqueConstraint(name="user_userid", columns={"user_userid"})})
 * @ORM\Entity
 */
class User
{
    /**
     * @var int
     *
     * @ORM\Column(name="user_id", type="integer", nullable=false, options={"unsigned"=true})
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $userId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="user_datec", type="date", nullable=false, options={"default"="0000-00-00"})
     */
    private $userDatec = '0000-00-00';

    /**
     * @var int
     *
     * @ORM\Column(name="user_creatorid", type="integer", nullable=false, options={"unsigned"=true})
     */
    private $userCreatorid = '0';

    /**
     * @var string
     *
     * @ORM\Column(name="user_name", type="string", length=50, nullable=false)
     */
    private $userName = '';

    /**
     * @var string
     *
     * @ORM\Column(name="user_email", type="string", length=100, nullable=false)
     */
    private $userEmail = '';

    /**
     * @var string
     *
     * @ORM\Column(name="user_wtel", type="string", length=50, nullable=false)
     */
    private $userWtel = '';

    /**
     * @var string
     *
     * @ORM\Column(name="user_htel", type="string", length=50, nullable=false)
     */
    private $userHtel = '';

    /**
     * @var string
     *
     * @ORM\Column(name="user_mtel", type="string", length=50, nullable=false)
     */
    private $userMtel = '';

    /**
     * @var string|null
     *
     * @ORM\Column(name="user_obs", type="text", length=16777215, nullable=true)
     */
    private $userObs;

    /**
     * @var bool
     *
     * @ORM\Column(name="user_plpriority", type="boolean", nullable=false)
     */
    private $userPlpriority = '0';

    /**
     * @var string
     *
     * @ORM\Column(name="user_userid", type="string", length=30, nullable=false)
     */
    private $userUserid = '';

    /**
     * @var string
     *
     * @ORM\Column(name="user_pass", type="string", length=30, nullable=false)
     */
    private $userPass = '';

    /**
     * @var bool
     *
     * @ORM\Column(name="user_active", type="boolean", nullable=false)
     */
    private $userActive = '0';

    /**
     * @var \Doctrine\Common\Collections\Collection
     *
     * @ORM\ManyToMany(targetEntity="RAN\Entity\Uright", inversedBy="user")
     * @ORM\JoinTable(name="useruright",
     *   joinColumns={
     *     @ORM\JoinColumn(name="user_id", referencedColumnName="user_id")
     *   },
     *   inverseJoinColumns={
     *     @ORM\JoinColumn(name="uright_id", referencedColumnName="uright_id")
     *   }
     * )
     */
    private $uright;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->uright = new \Doctrine\Common\Collections\ArrayCollection();
    }


    /**
     * Get userId.
     *
     * @return int
     */
    public function getUserId()
    {
        return $this->userId;
    }

    /**
     * Set userDatec.
     *
     * @param \DateTime $userDatec
     *
     * @return User
     */
    public function setUserDatec($userDatec)
    {
        $this->userDatec = $userDatec;

        return $this;
    }

    /**
     * Get userDatec.
     *
     * @return \DateTime
     */
    public function getUserDatec()
    {
        return $this->userDatec;
    }

    /**
     * Set userCreatorid.
     *
     * @param int $userCreatorid
     *
     * @return User
     */
    public function setUserCreatorid($userCreatorid)
    {
        $this->userCreatorid = $userCreatorid;

        return $this;
    }

    /**
     * Get userCreatorid.
     *
     * @return int
     */
    public function getUserCreatorid()
    {
        return $this->userCreatorid;
    }

    /**
     * Set userName.
     *
     * @param string $userName
     *
     * @return User
     */
    public function setUserName($userName)
    {
        $this->userName = $userName;

        return $this;
    }

    /**
     * Get userName.
     *
     * @return string
     */
    public function getUserName()
    {
        return $this->userName;
    }

    /**
     * Set userEmail.
     *
     * @param string $userEmail
     *
     * @return User
     */
    public function setUserEmail($userEmail)
    {
        $this->userEmail = $userEmail;

        return $this;
    }

    /**
     * Get userEmail.
     *
     * @return string
     */
    public function getUserEmail()
    {
        return $this->userEmail;
    }

    /**
     * Set userWtel.
     *
     * @param string $userWtel
     *
     * @return User
     */
    public function setUserWtel($userWtel)
    {
        $this->userWtel = $userWtel;

        return $this;
    }

    /**
     * Get userWtel.
     *
     * @return string
     */
    public function getUserWtel()
    {
        return $this->userWtel;
    }

    /**
     * Set userHtel.
     *
     * @param string $userHtel
     *
     * @return User
     */
    public function setUserHtel($userHtel)
    {
        $this->userHtel = $userHtel;

        return $this;
    }

    /**
     * Get userHtel.
     *
     * @return string
     */
    public function getUserHtel()
    {
        return $this->userHtel;
    }

    /**
     * Set userMtel.
     *
     * @param string $userMtel
     *
     * @return User
     */
    public function setUserMtel($userMtel)
    {
        $this->userMtel = $userMtel;

        return $this;
    }

    /**
     * Get userMtel.
     *
     * @return string
     */
    public function getUserMtel()
    {
        return $this->userMtel;
    }

    /**
     * Set userObs.
     *
     * @param string|null $userObs
     *
     * @return User
     */
    public function setUserObs($userObs = null)
    {
        $this->userObs = $userObs;

        return $this;
    }

    /**
     * Get userObs.
     *
     * @return string|null
     */
    public function getUserObs()
    {
        return $this->userObs;
    }

    /**
     * Set userPlpriority.
     *
     * @param bool $userPlpriority
     *
     * @return User
     */
    public function setUserPlpriority($userPlpriority)
    {
        $this->userPlpriority = $userPlpriority;

        return $this;
    }

    /**
     * Get userPlpriority.
     *
     * @return bool
     */
    public function getUserPlpriority()
    {
        return $this->userPlpriority;
    }

    /**
     * Set userUserid.
     *
     * @param string $userUserid
     *
     * @return User
     */
    public function setUserUserid($userUserid)
    {
        $this->userUserid = $userUserid;

        return $this;
    }

    /**
     * Get userUserid.
     *
     * @return string
     */
    public function getUserUserid()
    {
        return $this->userUserid;
    }

    /**
     * Set userPass.
     *
     * @param string $userPass
     *
     * @return User
     */
    public function setUserPass($userPass)
    {
        $this->userPass = $userPass;

        return $this;
    }

    /**
     * Get userPass.
     *
     * @return string
     */
    public function getUserPass()
    {
        return $this->userPass;
    }

    /**
     * Set userActive.
     *
     * @param bool $userActive
     *
     * @return User
     */
    public function setUserActive($userActive)
    {
        $this->userActive = $userActive;

        return $this;
    }

    /**
     * Get userActive.
     *
     * @return bool
     */
    public function getUserActive()
    {
        return $this->userActive;
    }

    /**
     * Add uright.
     *
     * @param \RAN\Entity\Uright $uright
     *
     * @return User
     */
    public function addUright(\RAN\Entity\Uright $uright)
    {
        $this->uright[] = $uright;

        return $this;
    }

    /**
     * Remove uright.
     *
     * @param \RAN\Entity\Uright $uright
     *
     * @return boolean TRUE if this collection contained the specified element, FALSE otherwise.
     */
    public function removeUright(\RAN\Entity\Uright $uright)
    {
        return $this->uright->removeElement($uright);
    }

    /**
     * Get uright.
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getUright()
    {
        return $this->uright;
    }
}
