<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Userlog
 *
 * @ORM\Table(name="userlog")
 * @ORM\Entity
 */
class Userlog
{
    /**
     * @var int
     *
     * @ORM\Column(name="userlog_id", type="integer", nullable=false, options={"unsigned"=true})
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $userlogId;

    /**
     * @var int
     *
     * @ORM\Column(name="user_id", type="integer", nullable=false, options={"unsigned"=true})
     */
    private $userId = '0';

    /**
     * @var string
     *
     * @ORM\Column(name="userlog_userid", type="string", length=30, nullable=false)
     */
    private $userlogUserid = '';

    /**
     * @var string
     *
     * @ORM\Column(name="userlog_name", type="string", length=100, nullable=false)
     */
    private $userlogName = '';

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="userlog_datelogin", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"})
     */
    private $userlogDatelogin = '0000-00-00 00:00:00';

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="userlog_datelogout", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"})
     */
    private $userlogDatelogout = '0000-00-00 00:00:00';

    /**
     * @var string
     *
     * @ORM\Column(name="userlog_ip", type="string", length=15, nullable=false)
     */
    private $userlogIp = '';

    /**
     * @var string
     *
     * @ORM\Column(name="userlog_sessid", type="string", length=100, nullable=false)
     */
    private $userlogSessid = '';



    /**
     * Get userlogId.
     *
     * @return int
     */
    public function getUserlogId()
    {
        return $this->userlogId;
    }

    /**
     * Set userId.
     *
     * @param int $userId
     *
     * @return Userlog
     */
    public function setUserId($userId)
    {
        $this->userId = $userId;

        return $this;
    }

    /**
     * Get userId.
     *
     * @return int
     */
    public function getUserId()
    {
        return $this->userId;
    }

    /**
     * Set userlogUserid.
     *
     * @param string $userlogUserid
     *
     * @return Userlog
     */
    public function setUserlogUserid($userlogUserid)
    {
        $this->userlogUserid = $userlogUserid;

        return $this;
    }

    /**
     * Get userlogUserid.
     *
     * @return string
     */
    public function getUserlogUserid()
    {
        return $this->userlogUserid;
    }

    /**
     * Set userlogName.
     *
     * @param string $userlogName
     *
     * @return Userlog
     */
    public function setUserlogName($userlogName)
    {
        $this->userlogName = $userlogName;

        return $this;
    }

    /**
     * Get userlogName.
     *
     * @return string
     */
    public function getUserlogName()
    {
        return $this->userlogName;
    }

    /**
     * Set userlogDatelogin.
     *
     * @param \DateTime $userlogDatelogin
     *
     * @return Userlog
     */
    public function setUserlogDatelogin($userlogDatelogin)
    {
        $this->userlogDatelogin = $userlogDatelogin;

        return $this;
    }

    /**
     * Get userlogDatelogin.
     *
     * @return \DateTime
     */
    public function getUserlogDatelogin()
    {
        return $this->userlogDatelogin;
    }

    /**
     * Set userlogDatelogout.
     *
     * @param \DateTime $userlogDatelogout
     *
     * @return Userlog
     */
    public function setUserlogDatelogout($userlogDatelogout)
    {
        $this->userlogDatelogout = $userlogDatelogout;

        return $this;
    }

    /**
     * Get userlogDatelogout.
     *
     * @return \DateTime
     */
    public function getUserlogDatelogout()
    {
        return $this->userlogDatelogout;
    }

    /**
     * Set userlogIp.
     *
     * @param string $userlogIp
     *
     * @return Userlog
     */
    public function setUserlogIp($userlogIp)
    {
        $this->userlogIp = $userlogIp;

        return $this;
    }

    /**
     * Get userlogIp.
     *
     * @return string
     */
    public function getUserlogIp()
    {
        return $this->userlogIp;
    }

    /**
     * Set userlogSessid.
     *
     * @param string $userlogSessid
     *
     * @return Userlog
     */
    public function setUserlogSessid($userlogSessid)
    {
        $this->userlogSessid = $userlogSessid;

        return $this;
    }

    /**
     * Get userlogSessid.
     *
     * @return string
     */
    public function getUserlogSessid()
    {
        return $this->userlogSessid;
    }
}
