<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Utilisateur
 *
 * @ORM\Table(name="utilisateur", indexes={@ORM\Index(name="fk_fk__acteur_role", columns={"rol_code"}), @ORM\Index(name="fk_fk_utilisateur_centre", columns={"cer_code"})})
 * @ORM\Entity
 */
class Utilisateur
{
    /**
     * @var string
     *
     * @ORM\Column(name="uti_identifiant", type="string", length=50, nullable=false)
     */
    private $utiIdentifiant;

    /**
     * @var string
     *
     * @ORM\Column(name="uti_password", type="string", length=50, nullable=false)
     */
    private $utiPassword;

    /**
     * @var string
     *
     * @ORM\Column(name="uti_email", type="string", length=150, nullable=false)
     */
    private $utiEmail;

    /**
     * @var int
     *
     * @ORM\Column(name="uti_cpt_bloque", type="integer", nullable=false)
     */
    private $utiCptBloque = '0';

    /**
     * @var int
     *
     * @ORM\Column(name="uti_no_faild_login", type="integer", nullable=false, options={"unsigned"=true})
     */
    private $utiNoFaildLogin = '0';

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="uti_chlg_date", type="datetime", nullable=true)
     */
    private $utiChlgDate;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="uti_pwd_date", type="datetime", nullable=true)
     */
    private $utiPwdDate;

    /**
     * @var \RAN\Entity\Role
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\Role")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="rol_code", referencedColumnName="rol_code")
     * })
     */
    private $rolCode;

    /**
     * @var \RAN\Entity\CentreDeRattachement
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\CentreDeRattachement")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="cer_code", referencedColumnName="cer_code")
     * })
     */
    private $cerCode;

    /**
     * @var \RAN\Entity\Personne
     *
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     * @ORM\OneToOne(targetEntity="RAN\Entity\Personne")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="per_code_uti", referencedColumnName="per_code")
     * })
     */
    private $perCodeUti;



    /**
     * Set utiIdentifiant.
     *
     * @param string $utiIdentifiant
     *
     * @return Utilisateur
     */
    public function setUtiIdentifiant($utiIdentifiant)
    {
        $this->utiIdentifiant = $utiIdentifiant;

        return $this;
    }

    /**
     * Get utiIdentifiant.
     *
     * @return string
     */
    public function getUtiIdentifiant()
    {
        return $this->utiIdentifiant;
    }

    /**
     * Set utiPassword.
     *
     * @param string $utiPassword
     *
     * @return Utilisateur
     */
    public function setUtiPassword($utiPassword)
    {
        $this->utiPassword = $utiPassword;

        return $this;
    }

    /**
     * Get utiPassword.
     *
     * @return string
     */
    public function getUtiPassword()
    {
        return $this->utiPassword;
    }

    /**
     * Set utiEmail.
     *
     * @param string $utiEmail
     *
     * @return Utilisateur
     */
    public function setUtiEmail($utiEmail)
    {
        $this->utiEmail = $utiEmail;

        return $this;
    }

    /**
     * Get utiEmail.
     *
     * @return string
     */
    public function getUtiEmail()
    {
        return $this->utiEmail;
    }

    /**
     * Set utiCptBloque.
     *
     * @param int $utiCptBloque
     *
     * @return Utilisateur
     */
    public function setUtiCptBloque($utiCptBloque)
    {
        $this->utiCptBloque = $utiCptBloque;

        return $this;
    }

    /**
     * Get utiCptBloque.
     *
     * @return int
     */
    public function getUtiCptBloque()
    {
        return $this->utiCptBloque;
    }

    /**
     * Set utiNoFaildLogin.
     *
     * @param int $utiNoFaildLogin
     *
     * @return Utilisateur
     */
    public function setUtiNoFaildLogin($utiNoFaildLogin)
    {
        $this->utiNoFaildLogin = $utiNoFaildLogin;

        return $this;
    }

    /**
     * Get utiNoFaildLogin.
     *
     * @return int
     */
    public function getUtiNoFaildLogin()
    {
        return $this->utiNoFaildLogin;
    }

    /**
     * Set utiChlgDate.
     *
     * @param \DateTime|null $utiChlgDate
     *
     * @return Utilisateur
     */
    public function setUtiChlgDate($utiChlgDate = null)
    {
        $this->utiChlgDate = $utiChlgDate;

        return $this;
    }

    /**
     * Get utiChlgDate.
     *
     * @return \DateTime|null
     */
    public function getUtiChlgDate()
    {
        return $this->utiChlgDate;
    }

    /**
     * Set utiPwdDate.
     *
     * @param \DateTime|null $utiPwdDate
     *
     * @return Utilisateur
     */
    public function setUtiPwdDate($utiPwdDate = null)
    {
        $this->utiPwdDate = $utiPwdDate;

        return $this;
    }

    /**
     * Get utiPwdDate.
     *
     * @return \DateTime|null
     */
    public function getUtiPwdDate()
    {
        return $this->utiPwdDate;
    }

    /**
     * Set rolCode.
     *
     * @param \RAN\Entity\Role|null $rolCode
     *
     * @return Utilisateur
     */
    public function setRolCode(\RAN\Entity\Role $rolCode = null)
    {
        $this->rolCode = $rolCode;

        return $this;
    }

    /**
     * Get rolCode.
     *
     * @return \RAN\Entity\Role|null
     */
    public function getRolCode()
    {
        return $this->rolCode;
    }

    /**
     * Set cerCode.
     *
     * @param \RAN\Entity\CentreDeRattachement|null $cerCode
     *
     * @return Utilisateur
     */
    public function setCerCode(\RAN\Entity\CentreDeRattachement $cerCode = null)
    {
        $this->cerCode = $cerCode;

        return $this;
    }

    /**
     * Get cerCode.
     *
     * @return \RAN\Entity\CentreDeRattachement|null
     */
    public function getCerCode()
    {
        return $this->cerCode;
    }

    /**
     * Set perCodeUti.
     *
     * @param \RAN\Entity\Personne $perCodeUti
     *
     * @return Utilisateur
     */
    public function setPerCodeUti(\RAN\Entity\Personne $perCodeUti)
    {
        $this->perCodeUti = $perCodeUti;

        return $this;
    }

    /**
     * Get perCodeUti.
     *
     * @return \RAN\Entity\Personne
     */
    public function getPerCodeUti()
    {
        return $this->perCodeUti;
    }
}
