<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * UtilisateurAuth
 *
 * @ORM\Table(name="utilisateur_auth", indexes={@ORM\Index(name="per_code_uti", columns={"per_code_uti"})})
 * @ORM\Entity
 */
class UtilisateurAuth
{
    /**
     * @var string
     *
     * @ORM\Column(name="auth_coord", type="string", length=4, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $authCoord = '';

    /**
     * @var int|null
     *
     * @ORM\Column(name="auth_valeur", type="integer", nullable=true)
     */
    private $authValeur;

    /**
     * @var \RAN\Entity\Utilisateur
     *
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     * @ORM\OneToOne(targetEntity="RAN\Entity\Utilisateur")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="per_code_uti", referencedColumnName="per_code_uti")
     * })
     */
    private $perCodeUti;



    /**
     * Set authCoord.
     *
     * @param string $authCoord
     *
     * @return UtilisateurAuth
     */
    public function setAuthCoord($authCoord)
    {
        $this->authCoord = $authCoord;

        return $this;
    }

    /**
     * Get authCoord.
     *
     * @return string
     */
    public function getAuthCoord()
    {
        return $this->authCoord;
    }

    /**
     * Set authValeur.
     *
     * @param int|null $authValeur
     *
     * @return UtilisateurAuth
     */
    public function setAuthValeur($authValeur = null)
    {
        $this->authValeur = $authValeur;

        return $this;
    }

    /**
     * Get authValeur.
     *
     * @return int|null
     */
    public function getAuthValeur()
    {
        return $this->authValeur;
    }

    /**
     * Set perCodeUti.
     *
     * @param \RAN\Entity\Utilisateur $perCodeUti
     *
     * @return UtilisateurAuth
     */
    public function setPerCodeUti(\RAN\Entity\Utilisateur $perCodeUti)
    {
        $this->perCodeUti = $perCodeUti;

        return $this;
    }

    /**
     * Get perCodeUti.
     *
     * @return \RAN\Entity\Utilisateur
     */
    public function getPerCodeUti()
    {
        return $this->perCodeUti;
    }
}
