<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * UtilisateurPwdReset
 *
 * @ORM\Table(name="utilisateur_pwd_reset", uniqueConstraints={@ORM\UniqueConstraint(name="upr_token", columns={"upr_token"})}, indexes={@ORM\Index(name="per_code_uti", columns={"per_code_uti"})})
 * @ORM\Entity
 */
class UtilisateurPwdReset
{
    /**
     * @var int
     *
     * @ORM\Column(name="upr_code", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $uprCode;

    /**
     * @var string
     *
     * @ORM\Column(name="upr_token", type="string", length=60, nullable=false)
     */
    private $uprToken;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="upr_date", type="datetime", nullable=false)
     */
    private $uprDate;

    /**
     * @var \RAN\Entity\Utilisateur
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\Utilisateur")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="per_code_uti", referencedColumnName="per_code_uti")
     * })
     */
    private $perCodeUti;



    /**
     * Get uprCode.
     *
     * @return int
     */
    public function getUprCode()
    {
        return $this->uprCode;
    }

    /**
     * Set uprToken.
     *
     * @param string $uprToken
     *
     * @return UtilisateurPwdReset
     */
    public function setUprToken($uprToken)
    {
        $this->uprToken = $uprToken;

        return $this;
    }

    /**
     * Get uprToken.
     *
     * @return string
     */
    public function getUprToken()
    {
        return $this->uprToken;
    }

    /**
     * Set uprDate.
     *
     * @param \DateTime $uprDate
     *
     * @return UtilisateurPwdReset
     */
    public function setUprDate($uprDate)
    {
        $this->uprDate = $uprDate;

        return $this;
    }

    /**
     * Get uprDate.
     *
     * @return \DateTime
     */
    public function getUprDate()
    {
        return $this->uprDate;
    }

    /**
     * Set perCodeUti.
     *
     * @param \RAN\Entity\Utilisateur|null $perCodeUti
     *
     * @return UtilisateurPwdReset
     */
    public function setPerCodeUti(\RAN\Entity\Utilisateur $perCodeUti = null)
    {
        $this->perCodeUti = $perCodeUti;

        return $this;
    }

    /**
     * Get perCodeUti.
     *
     * @return \RAN\Entity\Utilisateur|null
     */
    public function getPerCodeUti()
    {
        return $this->perCodeUti;
    }
}
