<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Alerte
 *
 * @ORM\Table(name="v_personne")
 * @ORM\Entity(readOnly=true)
 */
class VPersonne
{
    
    /**
     * @var \RAN\Entity\Personne
     *
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     * @ORM\OneToOne(targetEntity="RAN\Entity\Personne")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="per_code", referencedColumnName="per_code")
     * })
     */
    private $perCode;
    
    /**
     * @var string
     *
     * @ORM\Column(name="per_nom", type="string", length=50, nullable=false)
     */
    private $perNom;
    
    /**
     * @var string
     *
     * @ORM\Column(name="per_prenom", type="string", length=50, nullable=false)
     */
    private $perPrenom;
    
    /**
     * @var \RAN\Entity\CentreDeRattachement
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\CentreDeRattachement")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="cer_code", referencedColumnName="cer_code")
     * })
     */
    private $cerCode;
    
    /**
     * @var string
     *
     * @ORM\Column(name="cer_nom", type="string", length=50, nullable=false)
     */
    private $cerNom;
    
    /**
     * @var int
     *
     * @ORM\Column(name="civ_code", type="smallint", nullable=false)
     */
    private $civCode;
    
    /**
     * @var string
     *
     * @ORM\Column(name="civ_libelle_long", type="string", length=30, nullable=false)
     */
    private $civLibelleLong;
    
    /**
     * @var string
     *
     * @ORM\Column(name="civ_libelle_court", type="string", length=5, nullable=false)
     */
    private $civLibelleCourt;
    
    /**
     * @var \RAN\Entity\CentreDeRattachement
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\AdressePostale")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="adr_code", referencedColumnName="adr_code")
     * })
     */
    private $adrCode;
    
    /**
     * @var string
     *
     * @ORM\Column(name="adr_voie", type="string", length=200, nullable=false)
     */
    private $adrVoie;
    
    /**
     * @var string|null
     *
     * @ORM\Column(name="adr_cp", type="string", length=5, nullable=true)
     */
    private $adrCp;
    
    /**
     * @var string|null
     *
     * @ORM\Column(name="adr_ville", type="string", length=64, nullable=true)
     */
    private $adrVille;

    /**
     * Set cerCode.
     *
     * @param int|null $cerCode
     *
     * @return VPersonne
     */
    public function setCerCode($cerCode = null)
    {
        $this->cerCode = $cerCode;

        return $this;
    }

    /**
     * Get cerCode.
     *
     * @return int|null
     */
    public function getCerCode()
    {
        return $this->cerCode;
    }

    /**
     * Set cerNom.
     *
     * @param string $cerNom
     *
     * @return VPersonne
     */
    public function setCerNom($cerNom)
    {
        $this->cerNom = $cerNom;

        return $this;
    }

    /**
     * Get cerNom.
     *
     * @return string
     */
    public function getCerNom()
    {
        return $this->cerNom;
    }

    /**
     * Set perCode.
     *
     * @param int $perCode
     *
     * @return VPersonne
     */
    public function setPerCode($perCode)
    {
        $this->perCode = $perCode;

        return $this;
    }

    /**
     * Get perCode.
     *
     * @return int
     */
    public function getPerCode()
    {
        return $this->perCode;
    }

    /**
     * Set perNom.
     *
     * @param string $perNom
     *
     * @return VPersonne
     */
    public function setPerNom($perNom)
    {
        $this->perNom = $perNom;

        return $this;
    }

    /**
     * Get perNom.
     *
     * @return string
     */
    public function getPerNom()
    {
        return $this->perNom;
    }

    /**
     * Set perPrenom.
     *
     * @param string $perPrenom
     *
     * @return VPersonne
     */
    public function setPerPrenom($perPrenom)
    {
        $this->perPrenom = $perPrenom;

        return $this;
    }

    /**
     * Get perPrenom.
     *
     * @return string
     */
    public function getPerPrenom()
    {
        return $this->perPrenom;
    }

    /**
     * Set civLibelleLong.
     *
     * @param string $civLibelleLong
     *
     * @return VPersonne
     */
    public function setCivLibelleLong($civLibelleLong)
    {
        $this->civLibelleLong = $civLibelleLong;

        return $this;
    }

    /**
     * Get civLibelleLong.
     *
     * @return string
     */
    public function getCivLibelleLong()
    {
        return $this->civLibelleLong;
    }

    /**
     * Set civLibelleCourt.
     *
     * @param string $civLibelleCourt
     *
     * @return VPersonne
     */
    public function setCivLibelleCourt($civLibelleCourt)
    {
        $this->civLibelleCourt = $civLibelleCourt;

        return $this;
    }

    /**
     * Get civLibelleCourt.
     *
     * @return string
     */
    public function getCivLibelleCourt()
    {
        return $this->civLibelleCourt;
    }

    /**
     * Set adrCode.
     *
     * @param int $adrCode
     *
     * @return VPersonne
     */
    public function setAdrCode($adrCode)
    {
        $this->adrCode = $adrCode;

        return $this;
    }

    /**
     * Get adrCode.
     *
     * @return int
     */
    public function getAdrCode()
    {
        return $this->adrCode;
    }

    /**
     * Set adrVoie.
     *
     * @param string $adrVoie
     *
     * @return VPersonne
     */
    public function setAdrVoie($adrVoie)
    {
        $this->adrVoie = $adrVoie;

        return $this;
    }

    /**
     * Get adrVoie.
     *
     * @return string
     */
    public function getAdrVoie()
    {
        return $this->adrVoie;
    }

    /**
     * Set adrCp.
     *
     * @param string|null $adrCp
     *
     * @return VPersonne
     */
    public function setAdrCp($adrCp = null)
    {
        $this->adrCp = $adrCp;

        return $this;
    }

    /**
     * Get adrCp.
     *
     * @return string|null
     */
    public function getAdrCp()
    {
        return $this->adrCp;
    }

    /**
     * Set adrVille.
     *
     * @param string|null $adrVille
     *
     * @return VPersonne
     */
    public function setAdrVille($adrVille = null)
    {
        $this->adrVille = $adrVille;

        return $this;
    }

    /**
     * Get adrVille.
     *
     * @return string|null
     */
    public function getAdrVille()
    {
        return $this->adrVille;
    }

    /**
     * Set civCode.
     *
     * @param int $civCode
     *
     * @return VPersonne
     */
    public function setCivCode($civCode)
    {
        $this->civCode = $civCode;

        return $this;
    }

    /**
     * Get civCode.
     *
     * @return int
     */
    public function getCivCode()
    {
        return $this->civCode;
    }
}
